/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.vector;

import java.util.Iterator;
import java.util.List;
import javolution.context.ObjectFactory;
import javolution.lang.MathLib;
import javolution.util.FastComparator;
import javolution.util.FastMap;
import javolution.util.FastTable;
import javolution.util.Index;
import org.jscience.mathematics.structure.Field;
import org.jscience.mathematics.vector.DimensionException;
import org.jscience.mathematics.vector.Matrix;
import org.jscience.mathematics.vector.SparseVector;
import org.jscience.mathematics.vector.Vector;

public final class SparseMatrix<F extends Field<F>>
extends Matrix<F> {
    int _n;
    F _zero;
    boolean _transposed;
    final FastTable<SparseVector<F>> _rows = new FastTable();
    private static final ObjectFactory<SparseMatrix> FACTORY = new ObjectFactory<SparseMatrix>(){

        protected SparseMatrix create() {
            return new SparseMatrix();
        }

        protected void cleanup(SparseMatrix matrix) {
            matrix._rows.reset();
        }
    };
    private static final long serialVersionUID = 1L;

    public static <F extends Field<F>> SparseMatrix<F> valueOf(Vector<F> diagonal, F zero) {
        int n = diagonal.getDimension();
        SparseMatrix<F> M = SparseMatrix.newInstance(n, zero, false);
        int i = 0;
        while (i < n) {
            SparseVector<F> row = SparseVector.valueOf(n, zero, i, diagonal.get(i));
            M._rows.add(row);
            ++i;
        }
        return M;
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(SparseVector<F> ... rows) {
        int n = rows[0]._dimension;
        Object zero = rows[0]._zero;
        SparseMatrix M = SparseMatrix.newInstance(n, zero, false);
        int i = 0;
        int m = rows.length;
        while (i < m) {
            SparseVector<F> rowi = rows[i];
            if (rowi._dimension != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            if (!zero.equals(rowi._zero)) {
                throw new DimensionException("All vectors must have the same zero element.");
            }
            M._rows.add(rowi);
            ++i;
        }
        return M;
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(List<SparseVector<F>> rows) {
        int n = rows.get((int)0)._dimension;
        Object zero = rows.get((int)0)._zero;
        SparseMatrix M = SparseMatrix.newInstance(n, zero, false);
        Iterator<SparseVector<F>> iterator = rows.iterator();
        int i = 0;
        int m = rows.size();
        while (i < m) {
            SparseVector<F> rowi = iterator.next();
            if (rowi.getDimension() != n) {
                throw new DimensionException("All vectors must have the same dimension.");
            }
            if (!zero.equals(rowi._zero)) {
                throw new DimensionException("All vectors must have the same zero element.");
            }
            M._rows.add(rowi);
            ++i;
        }
        return M;
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(Matrix<F> that, F zero) {
        return SparseMatrix.valueOf(that, zero, FastComparator.DEFAULT);
    }

    public static <F extends Field<F>> SparseMatrix<F> valueOf(Matrix<F> that, F zero, FastComparator<? super F> comparator) {
        if (that instanceof SparseMatrix) {
            return (SparseMatrix)that;
        }
        int n = that.getNumberOfColumns();
        int m = that.getNumberOfRows();
        SparseMatrix<F> M = SparseMatrix.newInstance(n, zero, false);
        int i = 0;
        while (i < m) {
            SparseVector<? super F> rowi = SparseVector.valueOf(that.getRow(i), zero, comparator);
            M._rows.add(rowi);
            ++i;
        }
        return M;
    }

    public F getZero() {
        return this._zero;
    }

    @Override
    public int getNumberOfRows() {
        return this._transposed ? this._n : this._rows.size();
    }

    @Override
    public int getNumberOfColumns() {
        return this._transposed ? this._rows.size() : this._n;
    }

    @Override
    public F get(int i, int j) {
        return this._transposed ? ((SparseVector)this._rows.get(j)).get(i) : ((SparseVector)this._rows.get(i)).get(j);
    }

    @Override
    public SparseVector<F> getRow(int i) {
        if (!this._transposed) {
            return (SparseVector)this._rows.get(i);
        }
        int n = this._rows.size();
        int m = this._n;
        if (i < 0 || i >= m) {
            throw new DimensionException();
        }
        SparseVector<F> V = SparseVector.newInstance(n, this._zero);
        int j = 0;
        while (j < n) {
            SparseVector row = (SparseVector)this._rows.get(j);
            Field e = (Field)row._elements.get((Object)Index.valueOf((int)i));
            if (e != null) {
                V._elements.put((Object)Index.valueOf((int)j), (Object)e);
            }
            ++j;
        }
        return V;
    }

    @Override
    public SparseVector<F> getColumn(int j) {
        if (this._transposed) {
            return (SparseVector)this._rows.get(j);
        }
        int m = this._rows.size();
        if (j < 0 || j >= this._n) {
            throw new DimensionException();
        }
        SparseVector<F> V = SparseVector.newInstance(this._n, this._zero);
        int i = 0;
        while (i < m) {
            SparseVector row = (SparseVector)this._rows.get(i);
            Field e = (Field)row._elements.get((Object)Index.valueOf((int)j));
            if (e != null) {
                V._elements.put((Object)Index.valueOf((int)i), (Object)e);
            }
            ++i;
        }
        return V;
    }

    @Override
    public SparseVector<F> getDiagonal() {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int dimension = MathLib.min((int)m, (int)n);
        SparseVector<F> V = SparseVector.newInstance(this._n, this._zero);
        int i = 0;
        while (i < dimension) {
            SparseVector row = (SparseVector)this._rows.get(i);
            Field e = (Field)row._elements.get((Object)Index.valueOf((int)i));
            if (e != null) {
                V._elements.put((Object)Index.valueOf((int)i), (Object)e);
            }
            ++i;
        }
        return V;
    }

    @Override
    public SparseMatrix<F> opposite() {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((SparseVector)this._rows.get(i)).opposite());
            ++i;
        }
        return M;
    }

    @Override
    public SparseMatrix<F> plus(Matrix<F> that) {
        if (this.getNumberOfRows() != that.getNumberOfRows()) {
            throw new DimensionException();
        }
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((SparseVector)this._rows.get(i)).plus((Vector)(this._transposed ? that.getColumn(i) : that.getRow(i))));
            ++i;
        }
        return M;
    }

    @Override
    public SparseMatrix<F> minus(Matrix<F> that) {
        return this.plus((Matrix)that.opposite());
    }

    @Override
    public SparseMatrix<F> times(F k) {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int i = 0;
        int p = this._rows.size();
        while (i < p) {
            M._rows.add((Object)((SparseVector)this._rows.get(i)).times((Field)k));
            ++i;
        }
        return M;
    }

    @Override
    public SparseVector<F> times(Vector<F> v) {
        if (v.getDimension() != this.getNumberOfColumns()) {
            throw new DimensionException();
        }
        int m = this.getNumberOfRows();
        SparseVector<F> V = SparseVector.newInstance(m, this._zero);
        int i = 0;
        while (i < m) {
            F e = ((SparseVector)this.getRow(i)).times(v);
            if (!this._zero.equals(e)) {
                V._elements.put((Object)Index.valueOf((int)i), e);
            }
            ++i;
        }
        return V;
    }

    @Override
    public SparseMatrix<F> times(Matrix<F> that) {
        int m = this.getNumberOfRows();
        int n = this.getNumberOfColumns();
        int p = that.getNumberOfColumns();
        if (that.getNumberOfRows() != n) {
            throw new DimensionException();
        }
        FastTable<SparseVector<F>> rows = this.getRows();
        SparseMatrix<F> M = SparseMatrix.newInstance(m, this._zero, true);
        int j = 0;
        while (j < p) {
            Vector<F> thatColj = that.getColumn(j);
            SparseVector<F> column = SparseVector.newInstance(m, this._zero);
            M._rows.add(column);
            int i = 0;
            while (i < m) {
                F e = ((SparseVector)rows.get(i)).times(thatColj);
                if (!this._zero.equals(e)) {
                    column._elements.put((Object)Index.valueOf((int)i), e);
                }
                ++i;
            }
            ++j;
        }
        return M;
    }

    private FastTable<SparseVector<F>> getRows() {
        if (!this._transposed) {
            return this._rows;
        }
        FastTable rows = FastTable.newInstance();
        int i = 0;
        while (i < this._n) {
            rows.add((Object)this.getRow(i));
            ++i;
        }
        return rows;
    }

    @Override
    public SparseMatrix<F> inverse() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        Field detInv = (Field)this.determinant().inverse();
        Matrix A = this.adjoint();
        int i = 0;
        int m = ((SparseMatrix)A)._rows.size();
        while (i < m) {
            SparseVector row = (SparseVector)((SparseMatrix)A)._rows.get(i);
            FastMap.Entry e = row._elements.head();
            FastMap.Entry end = row._elements.tail();
            while ((e = e.getNext()) != end) {
                Field element = (Field)e.getValue();
                e.setValue((Object)detInv.times(element));
            }
            ++i;
        }
        return A;
    }

    @Override
    public F determinant() {
        if (!this.isSquare()) {
            throw new DimensionException("Matrix not square");
        }
        if (this._n == 1) {
            return this.get(0, 0);
        }
        Vector row0 = this.getRow(0);
        Field det = null;
        FastMap.Entry e = ((SparseVector)row0)._elements.head();
        FastMap.Entry end = ((SparseVector)row0)._elements.tail();
        while ((e = e.getNext()) != end) {
            int i = ((Index)e.getKey()).intValue();
            Field d = (Field)((Field)e.getValue()).times(this.cofactor(0, i));
            if (i % 2 != 0) {
                d = (Field)d.opposite();
            }
            Field field = det = det == null ? d : det.plus(d);
        }
        return (F)(det == null ? (Field)this._zero : det);
    }

    @Override
    public Matrix<F> solve(Matrix<F> y) {
        return ((SparseMatrix)this.inverse()).times((Matrix)y);
    }

    @Override
    public SparseMatrix<F> transpose() {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, !this._transposed);
        M._rows.addAll(this._rows);
        return M;
    }

    @Override
    public F cofactor(int i, int j) {
        if (this._transposed) {
            int k = i;
            i = j;
            j = k;
        }
        int m = this._rows.size();
        SparseMatrix<F> M = SparseMatrix.newInstance(m - 1, this._zero, this._transposed);
        int k1 = 0;
        while (k1 < m) {
            if (k1 != i) {
                SparseVector row = (SparseVector)this._rows.get(k1);
                SparseVector<F> V = SparseVector.newInstance(this._n - 1, this._zero);
                M._rows.add(V);
                FastMap.Entry e = row._elements.head();
                FastMap.Entry end = row._elements.tail();
                while ((e = e.getNext()) != end) {
                    int index = ((Index)e.getKey()).intValue();
                    if (index < j) {
                        V._elements.put((Object)((Index)e.getKey()), (Object)((Field)e.getValue()));
                        continue;
                    }
                    if (index <= j) continue;
                    V._elements.put((Object)Index.valueOf((int)(index - 1)), (Object)((Field)e.getValue()));
                }
            }
            ++k1;
        }
        return M.determinant();
    }

    @Override
    public SparseMatrix<F> adjoint() {
        SparseMatrix<F> M = SparseMatrix.newInstance(this._n, this._zero, this._transposed);
        int m = this._rows.size();
        int i = 0;
        while (i < m) {
            SparseVector<F> row = SparseVector.newInstance(this._n, this._zero);
            M._rows.add(row);
            int j = 0;
            while (j < this._n) {
                F cofactor;
                F f = cofactor = this._transposed ? this.cofactor(j, i) : this.cofactor(i, j);
                if (!this._zero.equals(cofactor)) {
                    row._elements.put((Object)Index.valueOf((int)j), (i + j) % 2 == 0 ? cofactor : (Field)cofactor.opposite());
                }
                ++j;
            }
            ++i;
        }
        return M.transpose();
    }

    @Override
    public SparseMatrix<F> tensor(Matrix<F> that) {
        int thism = this.getNumberOfRows();
        int thisn = this.getNumberOfColumns();
        int thatm = that.getNumberOfRows();
        int thatn = that.getNumberOfColumns();
        int n = thisn * thatn;
        int m = thism * thatm;
        SparseMatrix<F> M = SparseMatrix.newInstance(n, this._zero, false);
        int i = 0;
        while (i < m) {
            int i_rem_thatm = i % thatm;
            int i_div_thatm = i / thatm;
            SparseVector<F> row = SparseVector.newInstance(n, this._zero);
            M._rows.add(row);
            Vector thisRow = this.getRow(i_div_thatm);
            FastMap.Entry e = ((SparseVector)thisRow)._elements.head();
            FastMap.Entry end = ((SparseVector)thisRow)._elements.tail();
            while ((e = e.getNext()) != end) {
                Field a = (Field)e.getValue();
                int j = ((Index)e.getKey()).intValue();
                int k = 0;
                while (k < thatn) {
                    F b = that.get(i_rem_thatm, k);
                    if (!b.equals(this._zero)) {
                        row._elements.put((Object)Index.valueOf((int)(j * thatn + k)), (Object)((Field)a.times(b)));
                    }
                    ++k;
                }
            }
            ++i;
        }
        return M;
    }

    @Override
    public SparseVector<F> vectorization() {
        SparseVector<F> V = SparseVector.newInstance(this._n * this.getNumberOfRows(), this._zero);
        int offset = 0;
        int j = 0;
        int n = this.getNumberOfColumns();
        while (j < n) {
            Vector column = this.getColumn(j);
            FastMap.Entry e = ((SparseVector)column)._elements.head();
            FastMap.Entry end = ((SparseVector)column)._elements.tail();
            while ((e = e.getNext()) != end) {
                V._elements.put((Object)Index.valueOf((int)(((Index)e.getKey()).intValue() + offset)), (Object)((Field)e.getValue()));
            }
            offset += this.getNumberOfRows();
            ++j;
        }
        return V;
    }

    @Override
    public SparseMatrix<F> copy() {
        SparseMatrix<Field> M = SparseMatrix.newInstance(this._n, (Field)this._zero.copy(), this._transposed);
        for (SparseVector row : this._rows) {
            M._rows.add((Object)row.copy());
        }
        return M;
    }

    static <F extends Field<F>> SparseMatrix<F> newInstance(int n, F zero, boolean transposed) {
        SparseMatrix M = (SparseMatrix)FACTORY.object();
        M._n = n;
        M._zero = zero;
        M._transposed = transposed;
        return M;
    }

    private SparseMatrix() {
    }
}

