/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core.domination;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.opt4j.core.Constraint;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualSet;
import org.opt4j.core.IndividualSetListener;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.InfeasibilityConstraint;
import org.opt4j.core.Objectives;
import org.opt4j.core.Range;
import org.opt4j.core.Value;
import org.opt4j.core.domination.ConstraintChecker;
import org.opt4j.core.optimizer.Population;

@Singleton
public class ConstraintCheckerImpl
implements ConstraintChecker,
IndividualSetListener,
IndividualStateListener {
    protected Map<Constraint, Range> constraintRanges = new ConcurrentHashMap<Constraint, Range>();

    @Inject
    public ConstraintCheckerImpl(Population population) {
        population.addListener(this);
    }

    protected boolean isEligibleConstraint(Constraint constraint) {
        return constraint instanceof InfeasibilityConstraint;
    }

    protected boolean isIneligibleConstraint(Constraint constraint) {
        return !this.isEligibleConstraint(constraint);
    }

    @Override
    public double getConstraintViolation(Objectives o) {
        Iterator constraint_iterator = o.getConstraints().iterator();
        double violation = 0.0;
        while (constraint_iterator.hasNext()) {
            boolean isViolated = false;
            double violSingleConstraint = 0.0;
            Map.Entry entry = constraint_iterator.next();
            Constraint constraint = (Constraint)entry.getKey();
            Value<?> value = entry.getValue();
            if (this.isIneligibleConstraint(constraint)) continue;
            switch (constraint.getDirection()) {
                case less: {
                    if (value.getDouble() < constraint.getLimit()) break;
                    isViolated = true;
                    break;
                }
                case greater: {
                    if (value.getDouble() > constraint.getLimit()) break;
                    isViolated = true;
                    break;
                }
                case lessOrEqual: {
                    if (value.getDouble() <= constraint.getLimit()) break;
                    isViolated = true;
                    break;
                }
                case greaterOrEqual: {
                    if (value.getDouble() >= constraint.getLimit()) break;
                    isViolated = true;
                    break;
                }
                case equal: {
                    if (value.getDouble().doubleValue() == constraint.getLimit()) break;
                    isViolated = true;
                    break;
                }
                default: {
                    throw new RuntimeException("No matching case in switch statement: " + (Object)((Object)constraint.getDirection()));
                }
            }
            if (isViolated) {
                violSingleConstraint = Math.abs(value.getDouble() - constraint.getLimit());
                Range range = this.constraintRanges.get(constraint);
                if (range.getMin() != range.getMax()) {
                    violSingleConstraint /= range.getMax() - range.getMin();
                }
            }
            violation += violSingleConstraint;
        }
        return violation;
    }

    @Override
    public boolean isFeasible(Objectives o) {
        block7: for (Map.Entry entry : o.getConstraints()) {
            Constraint constraint = (Constraint)entry.getKey();
            Value<?> value = entry.getValue();
            if (this.isIneligibleConstraint(constraint)) continue;
            switch (constraint.getDirection()) {
                case less: {
                    if (value.getDouble() < constraint.getLimit()) continue block7;
                    return false;
                }
                case greater: {
                    if (value.getDouble() > constraint.getLimit()) continue block7;
                    return false;
                }
                case lessOrEqual: {
                    if (value.getDouble() <= constraint.getLimit()) continue block7;
                    return false;
                }
                case greaterOrEqual: {
                    if (value.getDouble() >= constraint.getLimit()) continue block7;
                    return false;
                }
                case equal: {
                    if (value.getDouble().doubleValue() == constraint.getLimit()) continue block7;
                    return false;
                }
                default: {
                    throw new RuntimeException("No matching case in switch statement: " + (Object)((Object)constraint.getDirection()));
                }
            }
        }
        return true;
    }

    @Override
    public void individualAdded(IndividualSet collection, Individual individual) {
    }

    @Override
    public void individualRemoved(IndividualSet collection, Individual individual) {
        for (Map.Entry entry : individual.getObjectives().getConstraints()) {
            Range range;
            if (this.isIneligibleConstraint((Constraint)entry.getKey()) || (range = this.constraintRanges.get(entry.getKey())) == null || entry.getValue().getDouble().doubleValue() != range.getMin() && entry.getValue().getDouble().doubleValue() != range.getMax()) continue;
            double currentMin = range.getMin();
            double currentMax = range.getMax();
            boolean currentMinStillExists = false;
            boolean currentMaxStillExists = false;
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            for (Individual individual2 : collection) {
                Value<?> v = individual2.getObjectives().getConstraints().get((Constraint)entry.getKey());
                if (v.getDouble() > max) {
                    max = v.getDouble();
                }
                if (v.getDouble() < min) {
                    min = v.getDouble();
                }
                if (v.getDouble() == currentMin) {
                    currentMinStillExists = true;
                }
                if (v.getDouble() == currentMax) {
                    currentMaxStillExists = true;
                }
                if (currentMaxStillExists && currentMinStillExists) break;
            }
            if (currentMaxStillExists && currentMinStillExists) continue;
            this.constraintRanges.remove(entry.getKey());
            this.constraintRanges.put((Constraint)entry.getKey(), new Range(min, max));
        }
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        if (!individual.isEvaluated()) {
            return;
        }
        for (Map.Entry entry : individual.getObjectives().getConstraints()) {
            if (this.isIneligibleConstraint((Constraint)entry.getKey())) continue;
            Range range = this.constraintRanges.get(entry.getKey());
            if (range == null) {
                Range r = new Range(entry.getValue().getDouble(), entry.getValue().getDouble());
                this.constraintRanges.put((Constraint)entry.getKey(), r);
                continue;
            }
            if (entry.getValue().getDouble() < range.getMin()) {
                range.setMin(entry.getValue().getDouble());
                continue;
            }
            if (!(entry.getValue().getDouble() > range.getMax())) continue;
            range.setMax(entry.getValue().getDouble());
        }
    }
}

