/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.diversity;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.CompositeGenotype;
import org.opt4j.operator.AbstractGenericOperator;
import org.opt4j.operator.diversity.Diversity;
import org.opt4j.operator.diversity.DiversityBoolean;
import org.opt4j.operator.diversity.DiversityDouble;
import org.opt4j.operator.diversity.DiversityInteger;
import org.opt4j.operator.diversity.DiversityPermutation;

@Singleton
public class DiversityGenericImplementation
extends AbstractGenericOperator<Diversity<Genotype>, Diversity<?>>
implements Diversity<Genotype> {
    @Inject
    protected DiversityGenericImplementation() {
        super(DiversityBoolean.class, DiversityDouble.class, DiversityInteger.class, DiversityPermutation.class);
    }

    @Override
    public double diversity(Genotype a, Genotype b) {
        Diversity diversity = (Diversity)this.getOperator(a);
        if (diversity == null) {
            return this.diversityComposite((CompositeGenotype)a, (CompositeGenotype)b);
        }
        return diversity.diversity(a, b);
    }

    protected double diversityComposite(CompositeGenotype<?, ?> a, CompositeGenotype<?, ?> b) {
        double diversity = 0.0;
        for (Object key : a.keySet()) {
            Genotype childA = (Genotype)a.get(key);
            Genotype childB = (Genotype)b.get(key);
            int size = childA.size();
            diversity += this.diversity(childA, childB) * (double)size;
        }
        return diversity / (double)a.size();
    }
}

