/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.de;

import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Order;
import org.opt4j.core.optimizer.MaxIterations;
import org.opt4j.core.optimizer.OptimizerModule;
import org.opt4j.optimizer.de.DifferentialEvolution;
import org.opt4j.start.Constant;

@Info(value="A population based optimization heuristic using vector differences.")
public class DifferentialEvolutionModule
extends OptimizerModule {
    @Info(value="The number of generations.")
    @Order(value=0)
    @MaxIterations
    protected int generations = 1000;
    @Info(value="The size of the population.")
    @Order(value=1)
    @Constant(value="alpha", namespace=DifferentialEvolution.class)
    protected int alpha = 100;
    @Info(value="The scaling factor F (0 <= F <= 2.0).")
    @Order(value=2)
    @Constant(value="scalingFactor", namespace=DifferentialEvolution.class)
    protected double scalingFactor = 0.5;

    public int getAlpha() {
        return this.alpha;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }

    public int getGenerations() {
        return this.generations;
    }

    public void setGenerations(int generations) {
        this.generations = generations;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double scalingFactor) {
        this.scalingFactor = scalingFactor;
    }

    @Override
    public void config() {
        this.bindOptimizer(DifferentialEvolution.class);
    }
}

