/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.UIManager;
import org.opt4j.config.Icons;
import org.opt4j.core.optimizer.Control;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerStateListener;
import org.opt4j.start.Constant;
import org.opt4j.viewer.StatusBar;
import org.opt4j.viewer.ToolBar;
import org.opt4j.viewer.Viewport;

public class Viewer
implements OptimizerStateListener {
    protected final Control control;
    protected final CloseEvent closeEvent;
    protected final boolean closeOnStop;
    protected final String title;
    protected final Viewport viewport;
    protected final ToolBar toolBar;
    protected final StatusBar statusBar;
    protected JFrame frame = null;

    @Inject
    public Viewer(Viewport viewport, ToolBar toolBar, StatusBar statusBar, Control control, @Constant(value="title", namespace=Viewer.class) @Constant(value="title", namespace=Viewer.class) String title, @Constant(value="closeEvent", namespace=Viewer.class) @Constant(value="closeEvent", namespace=Viewer.class) CloseEvent closeEvent, @Constant(value="closeOnStop", namespace=Viewer.class) @Constant(value="closeOnStop", namespace=Viewer.class) boolean closeOnStop) {
        this.viewport = viewport;
        this.toolBar = toolBar;
        this.statusBar = statusBar;
        this.title = title;
        this.control = control;
        this.closeEvent = closeEvent;
        this.closeOnStop = closeOnStop;
    }

    @Override
    public void optimizationStarted(Optimizer optimizer) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        final JFrame frame = this.frame = new JFrame();
        ImageIcon logo = Icons.getIcon("icons/logo2.png");
        frame.setIconImage(logo.getImage());
        frame.setTitle(this.title);
        frame.setLayout(new BorderLayout());
        frame.setPreferredSize(new Dimension(800, 600));
        this.toolBar.init();
        this.viewport.init();
        this.statusBar.init();
        frame.add((Component)this.toolBar.get(), "North");
        frame.add((Component)this.viewport.get(), "Center");
        frame.add((Component)this.statusBar.get(), "South");
        WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                switch (Viewer.this.closeEvent) {
                    case NONE: {
                        break;
                    }
                    case TERMINATE: {
                        Viewer.this.control.doTerminate();
                        break;
                    }
                    default: {
                        Viewer.this.control.doStop();
                    }
                }
                frame.dispose();
            }
        };
        frame.addWindowListener(windowListener);
        frame.setDefaultCloseOperation(0);
        frame.pack();
        frame.setVisible(true);
    }

    @Override
    public void optimizationStopped(Optimizer optimizer) {
        if (this.closeOnStop && this.frame != null) {
            this.frame.dispose();
        }
    }

    public static enum CloseEvent {
        NONE,
        STOP,
        TERMINATE;

    }
}

