/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.geography.coordinates;

import javax.measure.Measurable;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import javolution.context.ObjectFactory;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.geography.coordinates.Coordinates;
import org.jscience.geography.coordinates.crs.CoordinateReferenceSystem;
import org.jscience.geography.coordinates.crs.VerticalCRS;
import org.opengis.referencing.cs.CoordinateSystem;

public final class Altitude
extends Coordinates<VerticalCRS<?>>
implements Measurable<Length> {
    public static final VerticalCRS<Altitude> CRS = new VerticalCRS<Altitude>(){

        @Override
        protected Altitude coordinatesOf(CoordinateReferenceSystem.AbsolutePosition position) {
            return Altitude.valueOf(position.heightWGS84.doubleValue(SI.METRE), SI.METRE);
        }

        @Override
        protected CoordinateReferenceSystem.AbsolutePosition positionOf(Altitude coordinates, CoordinateReferenceSystem.AbsolutePosition position) {
            position.heightWGS84 = coordinates;
            return position;
        }

        @Override
        public CoordinateSystem getCoordinateSystem() {
            return VerticalCRS.HEIGHT_CS;
        }
    };
    private double _meters;
    private static final ObjectFactory<Altitude> FACTORY = new ObjectFactory<Altitude>(){

        protected Altitude create() {
            return new Altitude();
        }
    };
    static final XMLFormat<Altitude> XML = new XMLFormat<Altitude>(Altitude.class){

        public Altitude newInstance(Class<Altitude> cls, XMLFormat.InputElement xml) throws XMLStreamException {
            return (Altitude)FACTORY.object();
        }

        public void write(Altitude altitude, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("meters", altitude._meters);
        }

        public void read(XMLFormat.InputElement xml, Altitude altitude) throws XMLStreamException {
            altitude._meters = xml.getAttribute("meters", 0.0);
        }
    };
    private static final long serialVersionUID = 1L;

    public static Altitude valueOf(double value, Unit<Length> unit) {
        Altitude altitude = (Altitude)FACTORY.object();
        altitude._meters = unit == SI.METRE ? value : unit.getConverterTo(SI.METRE).convert(value);
        return altitude;
    }

    private Altitude() {
    }

    @Override
    public VerticalCRS<?> getCoordinateReferenceSystem() {
        return CRS;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        if (dimension == 0) {
            Unit<?> u = VerticalCRS.HEIGHT_CS.getAxis(0).getUnit();
            return SI.METRE.getConverterTo(u).convert(this._meters);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public final double doubleValue(Unit<Length> unit) {
        return unit == SI.METRE ? this._meters : SI.METRE.getConverterTo(unit).convert(this._meters);
    }

    @Override
    public final long longValue(Unit<Length> unit) {
        return Math.round(this.doubleValue(unit));
    }

    @Override
    public int compareTo(Measurable<Length> measure) {
        double meters = measure.doubleValue(SI.METRE);
        return this._meters > meters ? 1 : (this._meters < meters ? -1 : 0);
    }

    @Override
    public Altitude copy() {
        return Altitude.valueOf(this._meters, SI.METRE);
    }
}

