/*
 * Decompiled with CFR 0.152.
 */
package org.jscience.mathematics.number;

import javolution.context.LocalContext;
import javolution.context.ObjectFactory;
import javolution.text.Text;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.jscience.mathematics.number.LargeInteger;
import org.jscience.mathematics.number.Number;
import org.jscience.mathematics.structure.Field;

public final class ModuloInteger
extends Number<ModuloInteger>
implements Field<ModuloInteger> {
    public static final ModuloInteger ZERO = new ModuloInteger();
    public static final ModuloInteger ONE;
    static final XMLFormat<ModuloInteger> XML;
    private static final LocalContext.Reference<LargeInteger> MODULUS;
    private LargeInteger _value;
    private static final ObjectFactory<ModuloInteger> FACTORY;
    private static final long serialVersionUID = 1L;

    static {
        ModuloInteger.ZERO._value = LargeInteger.ZERO;
        ONE = new ModuloInteger();
        ModuloInteger.ONE._value = LargeInteger.ONE;
        XML = new XMLFormat<ModuloInteger>(ModuloInteger.class){

            public ModuloInteger newInstance(Class<ModuloInteger> cls, XMLFormat.InputElement xml) throws XMLStreamException {
                return ModuloInteger.valueOf((CharSequence)xml.getAttribute("value"));
            }

            public void write(ModuloInteger mi, XMLFormat.OutputElement xml) throws XMLStreamException {
                xml.setAttribute("value", (CharSequence)mi._value.toText());
            }

            public void read(XMLFormat.InputElement xml, ModuloInteger mi) {
            }
        };
        MODULUS = new LocalContext.Reference();
        FACTORY = new ObjectFactory<ModuloInteger>(){

            protected ModuloInteger create() {
                return new ModuloInteger();
            }
        };
    }

    public static ModuloInteger valueOf(LargeInteger value) {
        return ModuloInteger.newInstance(value);
    }

    public static ModuloInteger valueOf(CharSequence chars) {
        return ModuloInteger.newInstance(LargeInteger.valueOf(chars));
    }

    public static LargeInteger getModulus() {
        return (LargeInteger)MODULUS.get();
    }

    public static void setModulus(LargeInteger modulus) {
        if (modulus != null && !modulus.isPositive()) {
            throw new IllegalArgumentException("modulus: " + modulus + " has to be greater than 0");
        }
        MODULUS.set((Object)modulus);
    }

    public LargeInteger moduloValue() {
        LargeInteger modulus = (LargeInteger)MODULUS.get();
        return modulus == null ? this._value : this._value.mod(modulus);
    }

    @Override
    public Text toText() {
        return this.moduloValue().toText();
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof ModuloInteger ? this._value.equals(((ModuloInteger)that)._value) : false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }

    @Override
    public boolean isLargerThan(ModuloInteger that) {
        return this._value.isLargerThan(that._value);
    }

    @Override
    public long longValue() {
        return this.moduloValue().longValue();
    }

    @Override
    public double doubleValue() {
        return this.moduloValue().doubleValue();
    }

    @Override
    public int compareTo(ModuloInteger that) {
        return this._value.compareTo(that._value);
    }

    @Override
    public ModuloInteger times(ModuloInteger that) {
        LargeInteger value = this.moduloValue().times(that.moduloValue());
        LargeInteger modulus = (LargeInteger)MODULUS.get();
        return modulus == null ? ModuloInteger.valueOf(value) : ModuloInteger.valueOf(value.mod(modulus));
    }

    @Override
    public ModuloInteger plus(ModuloInteger that) {
        LargeInteger value = this.moduloValue().plus(that.moduloValue());
        LargeInteger modulus = (LargeInteger)MODULUS.get();
        return modulus == null ? ModuloInteger.valueOf(value) : ModuloInteger.valueOf(value.mod(modulus));
    }

    @Override
    public ModuloInteger opposite() {
        LargeInteger value = this.moduloValue().opposite();
        LargeInteger modulus = (LargeInteger)MODULUS.get();
        return modulus == null ? ModuloInteger.valueOf(value) : ModuloInteger.valueOf(value.mod(modulus));
    }

    @Override
    public ModuloInteger inverse() {
        LargeInteger modulus = (LargeInteger)MODULUS.get();
        if (modulus == null) {
            throw new ArithmeticException("Modulus not set");
        }
        return ModuloInteger.valueOf(this._value.modInverse(modulus));
    }

    private static ModuloInteger newInstance(LargeInteger value) {
        ModuloInteger m = (ModuloInteger)FACTORY.object();
        m._value = value;
        return m;
    }

    private ModuloInteger() {
    }

    @Override
    public ModuloInteger copy() {
        return ModuloInteger.newInstance(this._value.copy());
    }
}

