/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.common.logger;

import com.google.inject.Inject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import org.opt4j.common.logger.AbstractLogger;
import org.opt4j.common.logger.Logger;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.start.Constant;

public class TsvLogger
extends AbstractLogger
implements Logger {
    protected final Archive archive;
    private PrintWriter out;
    private long startTime = -1L;

    @Inject
    public TsvLogger(Archive archive, @Constant(value="filename", namespace=TsvLogger.class) @Constant(value="filename", namespace=TsvLogger.class) String filename, @Constant(value="evaluationStep", namespace=TsvLogger.class) @Constant(value="evaluationStep", namespace=TsvLogger.class) int evaluationStep, @Constant(value="iterationStep", namespace=TsvLogger.class) @Constant(value="iterationStep", namespace=TsvLogger.class) int iterationStep) {
        super(iterationStep, evaluationStep);
        this.archive = archive;
        this.out = this.initWriter(filename);
    }

    protected PrintWriter initWriter(String filename) {
        if (filename == null || filename.equals("")) {
            throw new IllegalArgumentException("File name must not be the empty string.");
        }
        File file = new File(filename);
        File dir = file.getParentFile();
        if (dir != null) {
            dir.mkdirs();
        }
        try {
            return new PrintWriter(new BufferedWriter(new FileWriter(file)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void optimizationStarted() {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void logEvent(int iteration, int evaluation) {
        assert (this.startTime != -1L) : "not initialized";
        double time = ((double)System.currentTimeMillis() - (double)this.startTime) / 1000.0;
        for (Individual individual : this.archive) {
            String output = this.getStatistics(iteration, evaluation, time);
            output = String.valueOf(output) + this.getIndividual(individual);
            this.out.println(output);
        }
        this.out.flush();
    }

    @Override
    public void optimizationStopped() {
        this.out.close();
    }

    @Override
    public void logHeader(Collection<Objective> objectives) {
        String header = String.valueOf(this.getCommentDelimiter()) + "iteration" + this.getColumnDelimiter() + "evaluations" + this.getColumnDelimiter() + "runtime[s]";
        for (Objective objective : objectives) {
            header = String.valueOf(header) + this.getColumnDelimiter() + objective.getName() + "[" + (Object)((Object)objective.getSign()) + "]";
        }
        this.out.println(header);
    }

    protected String getColumnDelimiter() {
        return "\t";
    }

    protected String getIndividual(Individual individual) {
        String output = "";
        Objectives objectives = individual.getObjectives();
        for (Objective objective : objectives.getKeys()) {
            String valueString;
            Value<?> value = objectives.get(objective);
            assert (value != null) : "Objective " + objective.getName() + " not set for individual " + individual;
            if (value == null || value.getValue() == null) {
                System.err.println(this + ": Value of objective " + objective.getName() + " is null.");
                valueString = "NULL";
            } else {
                String v = value.getValue().toString();
                if (v.contains("\t")) {
                    System.err.println(this + ":value must not contain the tab character:" + v);
                    v.replace("\t", "_");
                }
                valueString = v;
            }
            output = String.valueOf(output) + this.getColumnDelimiter() + valueString;
        }
        return output;
    }

    protected String getStatistics(int iteration, int evaluation, double time) {
        return String.valueOf(iteration) + this.getColumnDelimiter() + evaluation + this.getColumnDelimiter() + time;
    }

    protected String getCommentDelimiter() {
        return "";
    }
}

