/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.config;

import java.util.Collection;
import org.opt4j.config.Property;
import org.opt4j.config.Requirement;

public class EnumRequirement
implements Requirement {
    private final Property property;
    private final Collection<Object> elements;

    public EnumRequirement(Property property, Collection<Object> elements) {
        this.property = property;
        this.elements = elements;
        Class<?> type = property.getType();
        if (!type.isEnum()) {
            throw new IllegalArgumentException(property + " is not an enum.");
        }
    }

    @Override
    public Property getProperty() {
        return this.property;
    }

    @Override
    public boolean isFulfilled() {
        if (this.property.isActive()) {
            Object obj = this.property.getValue();
            return this.elements.contains(obj);
        }
        return false;
    }
}

