/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.core;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opt4j.core.Genotype;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.problem.Creator;

public class AbstractIndividualFactory<I extends Individual>
implements IndividualFactory {
    protected final Creator<Genotype> creator;
    protected final Provider<I> individualProvider;
    protected final Set<IndividualStateListener> individualStateListeners = new CopyOnWriteArraySet<IndividualStateListener>();

    public AbstractIndividualFactory(Provider<I> individualProvider, Creator creator) {
        this.individualProvider = individualProvider;
        this.creator = creator;
    }

    @Inject
    protected void injectListeners(Set<IndividualStateListener> listeners) {
        this.individualStateListeners.addAll(listeners);
    }

    @Override
    public void addIndividualStateListener(IndividualStateListener listener) {
        this.individualStateListeners.add(listener);
    }

    @Override
    public Individual create() {
        Individual individual = (Individual)this.individualProvider.get();
        individual.setIndividualStatusListeners(this.individualStateListeners);
        Genotype genotype = this.creator.create();
        individual.setGenotype(genotype);
        return individual;
    }

    @Override
    public Individual create(Genotype genotype) {
        Individual individual = (Individual)this.individualProvider.get();
        individual.setIndividualStatusListeners(this.individualStateListeners);
        individual.setGenotype(genotype);
        return individual;
    }

    @Override
    public void removeIndividualStateListener(IndividualStateListener listener) {
        this.individualStateListeners.remove(listener);
    }
}

