/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.algebra;

import com.google.inject.Inject;
import org.opt4j.core.Genotype;
import org.opt4j.genotype.DoubleGenotype;
import org.opt4j.operator.algebra.Algebra;
import org.opt4j.operator.algebra.Term;
import org.opt4j.operator.normalize.NormalizeDouble;

public class AlgebraDouble
implements Algebra<DoubleGenotype> {
    protected final NormalizeDouble normalize;

    @Inject
    public AlgebraDouble(NormalizeDouble normalize) {
        this.normalize = normalize;
    }

    @Override
    public DoubleGenotype algebra(Term term, Genotype ... genotypes) {
        int n = genotypes.length;
        assert (n > 0);
        DoubleGenotype[] list = new DoubleGenotype[n];
        int i = 0;
        while (i < n) {
            list[i] = (DoubleGenotype)genotypes[i];
            ++i;
        }
        DoubleGenotype offspring = (DoubleGenotype)list[0].newInstance();
        offspring.clear();
        int size = list[0].size();
        double[] values = new double[n];
        int j = 0;
        while (j < size) {
            int i2 = 0;
            while (i2 < n) {
                values[i2] = list[i2] == null ? 0.0 : (Double)list[i2].get(j);
                ++i2;
            }
            double result = term.calculate(values);
            offspring.add(result);
            ++j;
        }
        this.normalize.normalize(offspring);
        return offspring;
    }
}

