/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.crossover;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.genotype.PermutationGenotype;
import org.opt4j.operator.crossover.CrossoverPermutation;
import org.opt4j.optimizer.ea.Pair;
import org.opt4j.start.Constant;

public class CrossoverPermutationOnePoint
implements CrossoverPermutation {
    protected final Random random;
    protected final boolean rotation;

    @Inject
    public CrossoverPermutationOnePoint(Rand random, @Constant(value="rotation", namespace=CrossoverPermutationOnePoint.class) @Constant(value="rotation", namespace=CrossoverPermutationOnePoint.class) boolean rotation) {
        this.random = random;
        this.rotation = rotation;
    }

    @Override
    public Pair<PermutationGenotype<?>> crossover(PermutationGenotype<?> p1, PermutationGenotype<?> p2) {
        PermutationGenotype o1 = (PermutationGenotype)p1.newInstance();
        PermutationGenotype o2 = (PermutationGenotype)p1.newInstance();
        int size = p1.size();
        assert (size == p2.size()) : "Permutation is undefined for genotypes with different lengths.";
        assert (p1.containsAll(p2)) : "Permutation is undefined for different domains.";
        if (size > 0) {
            Object e2;
            Object e1;
            int pos;
            HashSet elements1 = new HashSet();
            HashSet elements2 = new HashSet();
            int offset = this.rotation ? this.random.nextInt(size) : 0;
            int cutpoint = this.random.nextInt(size);
            int i = 0;
            while (i < cutpoint) {
                pos = (offset + i) % size;
                e1 = p1.get(pos);
                e2 = p2.get(pos);
                o1.add(e1);
                o2.add(e2);
                elements1.add(e1);
                elements2.add(e2);
                ++i;
            }
            offset = this.rotation ? this.random.nextInt(size) : 0;
            i = 0;
            while (i < size) {
                pos = (offset + i) % size;
                e1 = p1.get(pos);
                e2 = p2.get(pos);
                if (!elements1.contains(e2)) {
                    o1.add(e2);
                }
                if (!elements2.contains(e1)) {
                    o2.add(e1);
                }
                ++i;
            }
        }
        Pair offspring = new Pair(o1, o2);
        return offspring;
    }
}

