/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.mutate;

import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Required;
import org.opt4j.operator.mutate.AdaptiveMutationRate;
import org.opt4j.operator.mutate.ConstantMutationRate;
import org.opt4j.operator.mutate.MutateDouble;
import org.opt4j.operator.mutate.MutateDoubleGauss;
import org.opt4j.operator.mutate.MutateDoublePolynomial;
import org.opt4j.operator.mutate.MutateModule;
import org.opt4j.operator.mutate.MutatePermutation;
import org.opt4j.operator.mutate.MutatePermutationInsert;
import org.opt4j.operator.mutate.MutatePermutationMixed;
import org.opt4j.operator.mutate.MutatePermutationRevert;
import org.opt4j.operator.mutate.MutatePermutationSwap;
import org.opt4j.operator.mutate.MutationRate;
import org.opt4j.start.Constant;

@Info(value="Setting for the basic mutate classOperators for genotype variation.")
public class BasicMutateModule
extends MutateModule {
    @Info(value="The type of mutation rate.")
    protected MutationRateType mutationRateType = MutationRateType.ADAPTIVE;
    @Info(value="The type of the mutate operator for the Permutation genotype.")
    protected PermutationType permutationType = PermutationType.MIXED;
    @Info(value="The type of the mutate operator for the Double genotype.")
    protected DoubleType doubleType = DoubleType.POLYNOMIAL;
    @Required(property="doubleType", elements={"POLYNOMIAL"})
    @Constant(value="eta", namespace=MutateDoublePolynomial.class)
    protected double eta = 20.0;
    @Required(property="doubleType", elements={"GAUSS"})
    @Constant(value="sigma", namespace=MutateDoubleGauss.class)
    protected double sigma = 0.1;
    @Required(property="mutationRateType", elements={"CONSTANT"})
    @Constant(value="rate", namespace=ConstantMutationRate.class)
    protected double mutationRate = 0.01;

    public MutationRateType getMutationRateType() {
        return this.mutationRateType;
    }

    public void setMutationRateType(MutationRateType mutationRateType) {
        this.mutationRateType = mutationRateType;
    }

    public double getMutationRate() {
        return this.mutationRate;
    }

    public void setMutationRate(double mutationRate) {
        this.mutationRate = mutationRate;
    }

    public PermutationType getPermutationType() {
        return this.permutationType;
    }

    public void setPermutationType(PermutationType permutationMode) {
        this.permutationType = permutationMode;
    }

    public DoubleType getDoubleType() {
        return this.doubleType;
    }

    public void setDoubleType(DoubleType doubleType) {
        this.doubleType = doubleType;
    }

    public double getEta() {
        return this.eta;
    }

    public void setEta(double eta) {
        this.eta = eta;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double sigma) {
        this.sigma = sigma;
    }

    @Override
    public void config() {
        switch (this.mutationRateType) {
            case ADAPTIVE: {
                this.bind(MutationRate.class).to(AdaptiveMutationRate.class).in(SINGLETON);
                break;
            }
            case CONSTANT: {
                this.bind(MutationRate.class).to(ConstantMutationRate.class).in(SINGLETON);
            }
        }
        Class permutation = MutatePermutationMixed.class;
        switch (this.permutationType) {
            case MIXED: {
                permutation = MutatePermutationMixed.class;
                break;
            }
            case SWAP: {
                permutation = MutatePermutationSwap.class;
                break;
            }
            case INSERT: {
                permutation = MutatePermutationInsert.class;
                break;
            }
            case REVERT: {
                permutation = MutatePermutationRevert.class;
            }
        }
        this.bind(MutatePermutation.class).to(permutation).in(SINGLETON);
        switch (this.doubleType) {
            case GAUSS: {
                this.bind(MutateDouble.class).to(MutateDoubleGauss.class).in(SINGLETON);
                break;
            }
            case POLYNOMIAL: {
                this.bind(MutateDouble.class).to(MutateDoublePolynomial.class).in(SINGLETON);
            }
        }
    }

    public static enum DoubleType {
        GAUSS,
        POLYNOMIAL;

    }

    public static enum MutationRateType {
        CONSTANT,
        ADAPTIVE;

    }

    public static enum PermutationType {
        MIXED,
        SWAP,
        INSERT,
        REVERT;

    }
}

