/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.mutate;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.genotype.PermutationGenotype;
import org.opt4j.operator.mutate.MutatePermutation;
import org.opt4j.operator.mutate.MutatePermutationInsert;
import org.opt4j.operator.mutate.MutatePermutationRevert;
import org.opt4j.operator.mutate.MutatePermutationSwap;

public class MutatePermutationMixed
implements MutatePermutation {
    protected final Random random;
    protected final MutatePermutationSwap swap;
    protected final MutatePermutationInsert insert;
    protected final MutatePermutationRevert revert;

    @Inject
    public MutatePermutationMixed(MutatePermutationSwap swap, MutatePermutationInsert insert, MutatePermutationRevert revert, Rand random) {
        this.swap = swap;
        this.insert = insert;
        this.revert = revert;
        this.random = random;
    }

    @Override
    public void mutate(PermutationGenotype<?> genotype, double p) {
        if (this.random.nextDouble() < 0.33) {
            this.swap.mutate(genotype, p);
        } else if (this.random.nextBoolean()) {
            this.insert.mutate(genotype, p);
        } else {
            this.revert.mutate(genotype, p);
        }
    }
}

