/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.operator.neighbor;

import com.google.inject.Inject;
import java.util.Random;
import org.opt4j.common.random.Rand;
import org.opt4j.genotype.PermutationGenotype;
import org.opt4j.operator.neighbor.NeighborPermutation;
import org.opt4j.operator.neighbor.NeighborPermutationInsert;
import org.opt4j.operator.neighbor.NeighborPermutationRevert;
import org.opt4j.operator.neighbor.NeighborPermutationSwap;

public class NeighborPermutationMixed
implements NeighborPermutation {
    protected final Random random;
    protected final NeighborPermutationSwap swap;
    protected final NeighborPermutationInsert insert;
    protected final NeighborPermutationRevert revert;

    @Inject
    public NeighborPermutationMixed(NeighborPermutationSwap swap, NeighborPermutationInsert insert, NeighborPermutationRevert revert, Rand random) {
        this.swap = swap;
        this.insert = insert;
        this.random = random;
        this.revert = revert;
    }

    @Override
    public void neighbor(PermutationGenotype<?> genotype) {
        if (this.random.nextDouble() < 0.33) {
            this.swap.neighbor(genotype);
        } else if (this.random.nextBoolean()) {
            this.insert.neighbor(genotype);
        } else {
            this.revert.neighbor(genotype);
        }
    }
}

