/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Parent;
import org.opt4j.optimizer.ea.Coupler;
import org.opt4j.optimizer.ea.CouplerDefault;
import org.opt4j.optimizer.ea.CouplerRandom;
import org.opt4j.optimizer.ea.CouplerUnique;
import org.opt4j.optimizer.ea.EvolutionaryAlgorithmModule;
import org.opt4j.optimizer.ea.MatingModule;

@Parent(value=EvolutionaryAlgorithmModule.class)
@Info(value="Basic strategies to determine couples from the set of parents for a crossover.")
public class BasicMatingModule
extends MatingModule {
    @Info(value="The type of couple operation")
    protected CouplerType type = CouplerType.DEFAULT;

    public CouplerType getType() {
        return this.type;
    }

    public void setType(CouplerType type) {
        this.type = type;
    }

    @Override
    public void config() {
        switch (this.type) {
            case RANDOM: {
                this.bind(Coupler.class).to(CouplerRandom.class).in(SINGLETON);
                break;
            }
            case UNIQUE: {
                this.bind(Coupler.class).to(CouplerUnique.class).in(SINGLETON);
                break;
            }
            default: {
                this.bind(Coupler.class).to(CouplerDefault.class).in(SINGLETON);
            }
        }
    }

    public static enum CouplerType {
        DEFAULT,
        RANDOM,
        UNIQUE;

    }
}

