/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.ea;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opt4j.common.random.Rand;
import org.opt4j.core.Individual;
import org.opt4j.core.Objectives;
import org.opt4j.optimizer.ea.Selector;
import org.opt4j.start.Constant;

public class Spea2
implements Selector {
    protected final Rand random;
    protected final int tournament;
    protected final Map<Individual, IndividualSet> map = new LinkedHashMap<Individual, IndividualSet>();
    protected final Set<IndividualSet> individualSets = new LinkedHashSet<IndividualSet>();
    protected final LinkedList<Integer> freeIDs = new LinkedList();
    protected double[][] distance;
    protected boolean fitnessDirty = true;

    @Inject
    public Spea2(@Constant(value="tournament", namespace=Spea2.class) @Constant(value="tournament", namespace=Spea2.class) int tournament, Rand random) {
        this.tournament = tournament;
        this.random = random;
    }

    @Override
    public void init(int maxsize) {
        int i = 0;
        while (i < maxsize) {
            this.freeIDs.add(i);
            ++i;
        }
        this.distance = new double[maxsize][maxsize];
    }

    @Override
    public Collection<Individual> getParents(int mu, Collection<Individual> population) {
        this.update(population);
        ArrayList<Individual> parents = new ArrayList<Individual>();
        ArrayList<Individual> candidates = new ArrayList<Individual>(population);
        int size = candidates.size();
        int i = 0;
        while (i < mu) {
            Individual winner = (Individual)candidates.get(this.random.nextInt(size));
            int j = 0;
            while (j < this.tournament) {
                double wDist;
                double oDist;
                double wFitness;
                Individual opponent = (Individual)candidates.get(this.random.nextInt(size));
                IndividualSet wWinner = this.map.get(winner);
                IndividualSet wOpponent = this.map.get(opponent);
                double oFitness = wWinner.getFitness();
                if (oFitness > (wFitness = (double)wOpponent.getFitness()) || winner == opponent) {
                    winner = opponent;
                } else if (oFitness == wFitness && (oDist = this.getMinDistance(wOpponent)) > (wDist = this.getMinDistance(wWinner))) {
                    winner = opponent;
                }
                ++j;
            }
            parents.add(winner);
            ++i;
        }
        assert (parents.size() == mu);
        return parents;
    }

    @Override
    public Collection<Individual> getLames(int lambda, Collection<Individual> population) {
        this.update(population);
        assert (lambda <= population.size());
        LinkedHashSet<Individual> lames = new LinkedHashSet<Individual>();
        if (lambda > 0) {
            List<IndividualSet> dominated = this.getDominated();
            if (this.countIndividuals(dominated) >= lambda) {
                Collections.sort(dominated);
                ArrayList lameCandidates = new ArrayList();
                int i = 0;
                while (lameCandidates.size() < lambda) {
                    lameCandidates.addAll(dominated.get(i));
                    ++i;
                }
                lames.addAll(lameCandidates.subList(0, lambda));
            } else {
                for (IndividualSet w0 : dominated) {
                    lames.addAll(w0);
                }
                for (Individual individual : this.getLamesFromNonDominated(lambda - lames.size())) {
                    lames.add(individual);
                }
            }
        }
        assert (lames.size() == lambda);
        return lames;
    }

    public Collection<Individual> getLamesFromNonDominated(int count) {
        LinkedHashSet<Individual> set = new LinkedHashSet<Individual>();
        while (set.size() < count) {
            Individual individual;
            int maxsize = 0;
            ArrayList<IndividualSet> candidates = new ArrayList<IndividualSet>();
            for (IndividualSet individualSet : this.getNonDominated()) {
                if (individualSet.size() > maxsize) {
                    maxsize = individualSet.size();
                    candidates.clear();
                }
                if (individualSet.size() != maxsize) continue;
                candidates.add(individualSet);
            }
            if (candidates.size() <= count - set.size()) {
                for (IndividualSet individualSet : candidates) {
                    individual = individualSet.first();
                    this.remove(individual);
                    set.add(individual);
                }
                continue;
            }
            for (IndividualSet individualSet : this.getNearest(count - set.size(), candidates)) {
                individual = individualSet.first();
                this.remove(individual);
                set.add(individual);
            }
        }
        assert (set.size() == count);
        return set;
    }

    protected List<IndividualSet> getNearest(int n, Collection<IndividualSet> candidates) {
        assert (candidates.size() > n);
        ArrayList<IndividualSet> lames = new ArrayList<IndividualSet>();
        LinkedHashMap orderedLists = new LinkedHashMap();
        for (IndividualSet w0 : candidates) {
            ArrayList<IndividualSet> list = new ArrayList<IndividualSet>();
            for (IndividualSet w1 : candidates) {
                if (w0 == w1) continue;
                w1.setNextDistance(this.distance(w0, w1));
                list.add(w1);
            }
            Collections.sort(list, new Comparator<IndividualSet>(){

                @Override
                public int compare(IndividualSet o1, IndividualSet o2) {
                    double v = o1.getNextDistance() - o2.getNextDistance();
                    if (v < 0.0) {
                        return -1;
                    }
                    if (v > 0.0) {
                        return 1;
                    }
                    return 0;
                }
            });
            orderedLists.put(w0, list);
        }
        while (lames.size() < n) {
            ArrayList lcandidates = new ArrayList(orderedLists.keySet());
            int size = lcandidates.size();
            int k = 0;
            while (k < size - 1) {
                double value;
                double min = Double.MAX_VALUE;
                for (IndividualSet candidate : lcandidates) {
                    value = this.distance(candidate, (IndividualSet)((List)orderedLists.get(candidate)).get(k));
                    min = Math.min(min, value);
                }
                Iterator it = lcandidates.iterator();
                while (it.hasNext()) {
                    IndividualSet candidate = (IndividualSet)it.next();
                    value = this.distance(candidate, (IndividualSet)((List)orderedLists.get(candidate)).get(k));
                    if (!(value > min)) continue;
                    it.remove();
                }
                if (lcandidates.size() == 1) break;
                ++k;
            }
            IndividualSet lame = (IndividualSet)lcandidates.get(0);
            lames.add(lame);
            orderedLists.remove(lame);
            for (List list : orderedLists.values()) {
                list.remove(lame);
            }
        }
        assert (lames.size() == n);
        return lames;
    }

    protected double getMinDistance(IndividualSet w0) {
        double min = Double.MAX_VALUE;
        for (IndividualSet w1 : this.individualSets) {
            if (w0 == w1) continue;
            min = Math.min(min, this.distance(w0, w1));
        }
        return min;
    }

    protected void update(Collection<Individual> population) {
        LinkedHashSet<Individual> popSet = new LinkedHashSet<Individual>(population);
        if (!popSet.equals(this.map.keySet())) {
            LinkedHashSet<Individual> adds = new LinkedHashSet<Individual>(popSet);
            adds.removeAll(this.map.keySet());
            LinkedHashSet<Individual> removes = new LinkedHashSet<Individual>(this.map.keySet());
            removes.removeAll(popSet);
            for (Individual individual : removes) {
                this.remove(individual);
            }
            for (Individual individual : adds) {
                this.add(individual);
            }
        }
        assert (population.size() == this.map.size());
        if (this.fitnessDirty) {
            this.calculateFitness();
            this.fitnessDirty = false;
        }
    }

    protected double distance(IndividualSet w0, IndividualSet w1) {
        return this.distance[w0.getId()][w1.getId()];
    }

    protected void add(Individual individual) {
        int id0 = this.freeIDs.removeFirst();
        IndividualSet w0 = new IndividualSet(individual, id0);
        IndividualSet eq = null;
        for (IndividualSet w1 : this.individualSets) {
            int id1 = w1.getId();
            double dist = this.calculateDistance(w0, w1);
            if (dist == 0.0) {
                eq = w1;
                break;
            }
            this.distance[id0][id1] = dist;
            this.distance[id1][id0] = dist;
        }
        if (eq != null) {
            this.freeIDs.add(id0);
            w0 = eq;
            w0.add(individual);
        } else {
            this.distance[id0][id0] = 0.0;
            this.individualSets.add(w0);
        }
        this.map.put(individual, w0);
        this.fitnessDirty = true;
    }

    protected void remove(Individual individual) {
        IndividualSet individualSet = this.map.remove(individual);
        if (individualSet.size() == 1) {
            this.individualSets.remove(individualSet);
            this.freeIDs.add(individualSet.getId());
        } else {
            individualSet.remove(individual);
        }
        this.fitnessDirty = true;
    }

    protected double calculateDistance(IndividualSet w0, IndividualSet w1) {
        return w0.getObjectives().distance(w1.getObjectives());
    }

    protected void calculateFitness() {
        for (IndividualSet individual : this.individualSets) {
            int s = 0;
            for (IndividualSet other : this.individualSets) {
                if (individual == other || !individual.dominates(other)) continue;
                s += other.size();
            }
            individual.setStrength(s);
        }
        for (IndividualSet individual : this.individualSets) {
            int f = 0;
            for (IndividualSet other : this.individualSets) {
                if (individual == other || !other.dominates(individual)) continue;
                f += other.getStrength() * other.size();
            }
            individual.setFitness(f);
        }
    }

    protected List<IndividualSet> getDominated() {
        ArrayList<IndividualSet> dominated = new ArrayList<IndividualSet>();
        for (IndividualSet w0 : this.individualSets) {
            if (!((double)w0.getFitness() > 0.0)) continue;
            dominated.add(w0);
        }
        return dominated;
    }

    protected List<IndividualSet> getNonDominated() {
        ArrayList<IndividualSet> dominated = new ArrayList<IndividualSet>();
        for (IndividualSet w0 : this.individualSets) {
            if ((double)w0.getFitness() != 0.0) continue;
            dominated.add(w0);
        }
        return dominated;
    }

    private int countIndividuals(Collection<IndividualSet> collection) {
        int c = 0;
        for (IndividualSet w : collection) {
            c += w.size();
        }
        return c;
    }

    private class IndividualSet
    extends LinkedHashSet<Individual>
    implements Comparable<IndividualSet> {
        private static final long serialVersionUID = 1L;
        protected final int id;
        protected int fitness;
        protected int strength;
        protected final Objectives objectives;
        protected double nextDistance = 0.0;

        IndividualSet(Individual individual, int id) {
            this.id = id;
            this.add(individual);
            this.objectives = individual.getObjectives();
            this.fitness = 0;
            this.strength = 0;
        }

        public Objectives getObjectives() {
            return this.objectives;
        }

        public int getFitness() {
            return this.fitness;
        }

        public void setFitness(int fitness) {
            this.fitness = fitness;
        }

        public int getStrength() {
            return this.strength;
        }

        public void setStrength(int strength) {
            this.strength = strength;
        }

        public Individual first() {
            assert (this.size() != 0);
            return (Individual)this.iterator().next();
        }

        public int getId() {
            return this.id;
        }

        public double getNextDistance() {
            return this.nextDistance;
        }

        public void setNextDistance(double nextDistance) {
            this.nextDistance = nextDistance;
        }

        @Override
        public int hashCode() {
            return this.id;
        }

        @Override
        public boolean equals(Object obj) {
            IndividualSet other = (IndividualSet)obj;
            return this.id == other.id;
        }

        public boolean dominates(IndividualSet individualSet) {
            return this.getObjectives().dominates(individualSet.getObjectives());
        }

        @Override
        public int compareTo(IndividualSet o) {
            return o.fitness - this.fitness;
        }
    }
}

