/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.optimizer.mopso;

import org.opt4j.config.annotations.Info;
import org.opt4j.config.annotations.Name;
import org.opt4j.config.annotations.Order;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.optimizer.MaxIterations;
import org.opt4j.core.optimizer.OptimizerModule;
import org.opt4j.optimizer.mopso.MOPSO;
import org.opt4j.optimizer.mopso.MutateDoubleNonUniform;
import org.opt4j.optimizer.mopso.MutateDoubleUniform;
import org.opt4j.optimizer.mopso.ParticleFactory;
import org.opt4j.start.Constant;

@Info(value="Multi-objective particle swarm optimizer. Mostly based on the OMOPSO. Works only with real-valued problems.")
public class MOPSOModule
extends OptimizerModule {
    @Info(value="The number of particles.")
    @Order(value=1)
    @Constant(value="size", namespace=MOPSO.class)
    protected int particles = 100;
    @Info(value="The archive size of the global leaders.")
    @Name(value="archive size")
    @Order(value=2)
    @Constant(value="archiveSize", namespace=MOPSO.class)
    protected int archiveSize = 100;
    @Info(value="The number of iterations.")
    @Order(value=0)
    @MaxIterations
    protected int iterations = 1000;
    @Info(value="The perturbation index for the mutation.")
    @Order(value=3)
    protected double perturbation = 0.5;

    public double getPerturbation() {
        return this.perturbation;
    }

    public void setPerturbation(double perturbation) {
        this.perturbation = perturbation;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setIterations(int iterations) {
        this.iterations = iterations;
    }

    public int getParticles() {
        return this.particles;
    }

    public void setParticles(int particles) {
        this.particles = particles;
    }

    public int getArchiveSize() {
        return this.archiveSize;
    }

    public void setArchiveSize(int archiveSize) {
        this.archiveSize = archiveSize;
    }

    @Override
    protected void config() {
        this.bindOptimizer(MOPSO.class);
        this.bind(IndividualFactory.class).to(ParticleFactory.class);
        this.bindConstant("perturbation", MutateDoubleNonUniform.class).to(this.perturbation);
        this.bindConstant("perturbation", MutateDoubleUniform.class).to(this.perturbation);
    }
}

