/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.start;

import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.opt4j.config.Icons;
import org.opt4j.config.visualization.About;
import org.opt4j.config.visualization.ApplicationFrame;
import org.opt4j.config.visualization.Startupable;

@Singleton
public class Opt4JAbout
extends JPanel
implements About,
Startupable {
    public static final String DATE = "@DATE@";
    public static final String VERSION = "@VERSION@";
    public static final String[] AUTHORS = new String[]{"Martin Lukasiewycz", "Michael Gla&szlig;", "Sabine Helwig", "Felix Reimann"};
    private static final String LICENSE_TEXT = "Opt4J is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.\n\nOpt4J is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.\n\nYou should have received a copy of the GNU Lesser General Public License along with Opt4J. If not, see LGPL-License.";

    @Override
    public void startup() {
        Opt4JAbout content = this;
        content.setLayout(new BorderLayout());
        JLabel logoLabel = new JLabel(Icons.getIcon("img/top_logo.png"));
        logoLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel logo = new JPanel(new BorderLayout());
        logo.setBackground(Color.WHITE);
        logo.add(logoLabel);
        content.add((Component)logo, "First");
        JTextPane license = new JTextPane();
        license.setEditable(false);
        final JScrollPane licenseScroll = new JScrollPane(license);
        licenseScroll.setVerticalScrollBarPolicy(22);
        StyledDocument doc = license.getStyledDocument();
        Style regular = StyleContext.getDefaultStyleContext().getStyle("default");
        try {
            doc.insertString(doc.getLength(), LICENSE_TEXT, regular);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        license.setPreferredSize(new Dimension(360, 100));
        content.add((Component)licenseScroll, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                licenseScroll.getVerticalScrollBar().setValue(0);
            }
        });
        JPanel footer = new JPanel(new BorderLayout());
        footer.setBackground(Color.WHITE);
        String copyright = "<html>Build @DATE@ <br /> Version @VERSION@   \u00a9 Opt4J.org 2007</html>";
        JLabel copyrightLabel = new JLabel(copyright);
        copyrightLabel.setHorizontalAlignment(0);
        copyrightLabel.setVerticalAlignment(3);
        copyrightLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        footer.add((Component)copyrightLabel, "East");
        String credits = "<html><p>Credits:<br />";
        String[] stringArray = AUTHORS;
        int n = AUTHORS.length;
        int n2 = 0;
        while (n2 < n) {
            String author = stringArray[n2];
            credits = String.valueOf(credits) + author + "<br/>";
            ++n2;
        }
        credits = String.valueOf(credits) + "</p></html>";
        JLabel creditsLabel = new JLabel(credits);
        creditsLabel.setHorizontalAlignment(0);
        creditsLabel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        footer.add((Component)creditsLabel, "West");
        content.add((Component)footer, "Last");
    }

    @Override
    public JDialog getDialog(ApplicationFrame frame) {
        JDialog dialog = new JDialog(frame, "About Opt4J", true);
        dialog.setBackground(Color.WHITE);
        dialog.setDefaultCloseOperation(2);
        dialog.setResizable(false);
        Opt4JAbout content = new Opt4JAbout();
        content.startup();
        dialog.add(content);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension window = dialog.getPreferredSize();
        dialog.setLocation((screen.width - window.width) / 2, (screen.height - window.height) / 2);
        return dialog;
    }
}

