/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opt4j.core.Individual;
import org.opt4j.core.Objective;
import org.opt4j.core.Objectives;
import org.opt4j.core.Value;
import org.opt4j.core.optimizer.Archive;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.viewer.ObjectivesMonitor;

@Singleton
class ConvergencePlotData
implements OptimizerIterationListener,
ObjectivesMonitor.ObjectivesListener {
    protected final Map<Objective, PlotDataObjective> map = new HashMap<Objective, PlotDataObjective>();
    protected int iteration = 0;
    private final Archive archive;
    private boolean init = false;

    @Inject
    public ConvergencePlotData(Archive archive, ObjectivesMonitor objectivesMonitor) {
        this.archive = archive;
        objectivesMonitor.addListener(this);
    }

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        this.iteration = iteration;
        for (PlotDataObjective data : this.map.values()) {
            for (Individual individual : this.archive) {
                data.update(individual.getObjectives());
            }
            data.complete(iteration);
        }
    }

    public List<Point2D.Double> getMinPoints(Objective objective) {
        PlotDataObjective plotDataObjective = this.map.get(objective);
        assert (plotDataObjective != null);
        return plotDataObjective.minValues;
    }

    public List<Point2D.Double> getMaxPoints(Objective objective) {
        if (!this.init) {
            return Collections.emptyList();
        }
        PlotDataObjective plotDataObjective = this.map.get(objective);
        assert (plotDataObjective != null);
        return plotDataObjective.maxValues;
    }

    public List<Point2D.Double> getMeanPoints(Objective objective) {
        if (!this.init) {
            return Collections.emptyList();
        }
        PlotDataObjective plotDataObjective = this.map.get(objective);
        assert (plotDataObjective != null);
        return plotDataObjective.meanValues;
    }

    public int getIteration() {
        return this.iteration;
    }

    @Override
    public void objectives(Collection<Objective> objectives) {
        for (Objective obj : objectives) {
            this.map.put(obj, new PlotDataObjective(obj));
        }
        this.init = true;
    }

    protected static class PlotDataObjective {
        protected final Objective objective;
        protected final List<Point2D.Double> minValues = new CopyOnWriteArrayList<Point2D.Double>();
        protected final List<Point2D.Double> maxValues = new CopyOnWriteArrayList<Point2D.Double>();
        protected final List<Point2D.Double> meanValues = new CopyOnWriteArrayList<Point2D.Double>();
        protected final int MAXVALUES = 2000;
        final Set<Double> currentIteration = new HashSet<Double>();

        PlotDataObjective(Objective objective) {
            this.objective = objective;
        }

        public void update(Objectives objectives) {
            Value<?> value = objectives.get(this.objective);
            Object v = value.getValue();
            if (v != null && v instanceof Number) {
                Number n = (Number)v;
                double nextValue = n.doubleValue();
                this.currentIteration.add(nextValue);
            }
        }

        protected synchronized void simplify(List<Point2D.Double> values) {
            if (values.size() > 2000) {
                ArrayList<Point2D.Double> copy = new ArrayList<Point2D.Double>(values);
                final HashMap<Point2D.Double, Double> dist = new HashMap<Point2D.Double, Double>();
                int i = 1;
                while (i < copy.size() - 1) {
                    Point2D.Double p0 = (Point2D.Double)copy.get(i - 1);
                    Point2D.Double p1 = (Point2D.Double)copy.get(i);
                    Point2D.Double p2 = (Point2D.Double)copy.get(i + 1);
                    double slope = (p2.y - p0.y) / (p2.x - p0.x);
                    double y = p0.y + slope * (p1.x - p0.x);
                    double v = Math.abs(y - p1.y);
                    dist.put(p1, v);
                    i += 2;
                }
                copy.clear();
                copy.addAll(dist.keySet());
                Collections.sort(copy, new Comparator<Point2D.Double>(){

                    @Override
                    public int compare(Point2D.Double p1, Point2D.Double p2) {
                        Double v1 = (Double)dist.get(p1);
                        Double v2 = (Double)dist.get(p2);
                        return v1.compareTo(v2);
                    }
                });
                values.removeAll(copy.subList(0, copy.size() / 2));
            }
        }

        public void complete(int iteration) {
            double min = Double.MAX_VALUE;
            double max = Double.MIN_VALUE;
            double avg = 0.0;
            for (double value : this.currentIteration) {
                if (min > value) {
                    min = value;
                }
                if (max < value) {
                    max = value;
                }
                avg += value;
            }
            this.currentIteration.clear();
            this.addValue(min, this.minValues, iteration);
            this.addValue(max, this.maxValues, iteration);
            this.addValue(avg /= (double)this.currentIteration.size(), this.meanValues, iteration);
            if (iteration % 10 == 0) {
                if (this.minValues.size() > 2000) {
                    this.simplify(this.minValues);
                }
                if (this.maxValues.size() > 2000) {
                    this.simplify(this.maxValues);
                }
                if (this.meanValues.size() > 2000) {
                    this.simplify(this.meanValues);
                }
            }
        }

        private void addValue(double min, List<Point2D.Double> points, int iteration) {
            if (!Double.isInfinite(min) && (points.isEmpty() || points.get(points.size() - 1).getY() != min)) {
                if (!points.isEmpty()) {
                    Point2D.Double steppoint = new Point2D.Double(iteration, points.get(points.size() - 1).getY());
                    points.add(steppoint);
                }
                Point2D.Double point = new Point2D.Double(iteration, min);
                points.add(point);
            }
        }
    }
}

