/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

public class DelayTask {
    private final DelayThread thread;

    public DelayTask(long delay) {
        this(delay, 5);
    }

    public DelayTask(long delay, int priority) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Delay is negative:" + delay);
        }
        this.thread = new DelayThread(delay);
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Invalid priority: " + priority);
        }
        this.thread.setPriority(priority);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void execute(Runnable task) {
        this.thread.updateTask(task);
    }

    protected void finalize() throws Throwable {
        this.thread.doStop();
        super.finalize();
    }

    private static class DelayThread
    extends Thread {
        private Runnable task = null;
        private boolean run = true;
        private final long delay;

        public DelayThread(long delay) {
            this.delay = delay;
        }

        public synchronized void doStop() {
            this.run = false;
            this.notify();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.run) {
                Runnable task = this.getTaskAndSetToNull();
                if (task != null) {
                    task.run();
                    try {
                        DelayThread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                DelayThread delayThread = this;
                synchronized (delayThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        protected synchronized Runnable getTaskAndSetToNull() {
            Runnable t = this.task;
            this.task = null;
            return t;
        }

        public synchronized void updateTask(Runnable task) {
            this.task = task;
            this.notify();
        }
    }
}

