/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.opt4j.core.Individual;
import org.opt4j.core.IndividualFactory;
import org.opt4j.core.IndividualStateListener;
import org.opt4j.core.Objective;
import org.opt4j.core.optimizer.Archive;

@Singleton
public class ObjectivesMonitor
implements IndividualStateListener {
    protected boolean done = false;
    protected List<Objective> objectives = null;
    protected Set<ObjectivesListener> listeners = new CopyOnWriteArraySet<ObjectivesListener>();

    @Inject
    public ObjectivesMonitor(IndividualFactory individualFactory, Archive archive) {
        individualFactory.addIndividualStateListener(this);
        if (!archive.isEmpty()) {
            this.publishObjectives(archive.iterator().next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ObjectivesListener listener) {
        ObjectivesMonitor objectivesMonitor = this;
        synchronized (objectivesMonitor) {
            if (this.done) {
                listener.objectives(this.objectives);
            } else {
                this.listeners.add(listener);
            }
        }
    }

    public void removeListener(ObjectivesListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void inidividualStateChanged(Individual individual) {
        if (!this.done && individual.getState() == Individual.State.EVALUATED) {
            this.publishObjectives(individual);
        }
    }

    protected synchronized void publishObjectives(Individual individual) {
        if (!this.done) {
            this.objectives = new ArrayList<Objective>(individual.getObjectives().getKeys());
            for (ObjectivesListener listener : this.listeners) {
                listener.objectives(this.objectives);
            }
            Collections.sort(this.objectives);
            this.done = true;
        }
    }

    public static interface ObjectivesListener {
        public void objectives(Collection<Objective> var1);
    }
}

