/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class QTable
extends JTable {
    private static final long serialVersionUID = 1L;

    public QTable(TableModel dm) {
        super(dm);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (c instanceof JComponent) {
            JComponent jc = (JComponent)c;
            Object value = this.getValueAt(row, column);
            if (value != null) {
                String text = value.toString();
                int length = jc.getFontMetrics(jc.getFont()).stringWidth(text);
                if (this.getColumnModel().getColumn(column).getWidth() < length) {
                    jc.setToolTipText(text);
                } else {
                    jc.setToolTipText(null);
                }
            }
        }
        return c;
    }

    @Override
    public JToolTip createToolTip() {
        return new WrapToolTip();
    }

    class WrapToolTip
    extends JToolTip {
        private static final long serialVersionUID = 1L;

        WrapToolTip() {
        }

        @Override
        public void setTipText(String tipText) {
            if (tipText != null && tipText.length() > 0) {
                String s = "<html>";
                int i = 0;
                while (i < tipText.length()) {
                    s = String.valueOf(s) + tipText.substring(i, Math.min(i + 150, tipText.length()));
                    s = String.valueOf(s) + "<br>";
                    i += 150;
                }
                s = String.valueOf(s) + "</html>";
                super.setTipText(s);
            } else {
                super.setTipText(null);
            }
        }
    }
}

