/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import org.opt4j.core.optimizer.Optimizer;
import org.opt4j.core.optimizer.OptimizerIterationListener;
import org.opt4j.core.optimizer.OptimizerStateListener;
import org.opt4j.viewer.DelayTask;
import org.opt4j.viewer.Progress;

public class StatusBar
implements OptimizerIterationListener,
OptimizerStateListener {
    protected final Progress progress;
    protected final DelayTask task = new DelayTask(40L);
    protected final JLabel label = new JLabel();
    protected final JLabel timeLabel = new JLabel();
    protected final JProgressBar bar = new JProgressBar();
    protected final JPanel panel = new JPanel();
    protected long time;

    @Inject
    public StatusBar(Progress progress) {
        this.progress = progress;
    }

    public void init() {
        this.panel.setLayout(new BorderLayout());
        MatteBorder border = BorderFactory.createMatteBorder(1, 0, 0, 0, this.label.getBackground().darker());
        this.panel.setBorder(border);
        JPanel containerText = new JPanel(new FlowLayout(0, 5, 0));
        this.timeLabel.setText("[time per iteration in ms]");
        this.timeLabel.setHorizontalAlignment(2);
        this.label.setPreferredSize(new Dimension(50, 18));
        this.label.setHorizontalAlignment(4);
        this.label.setPreferredSize(new Dimension(50, 18));
        containerText.add(this.label);
        containerText.add(this.timeLabel);
        this.panel.add((Component)containerText, "West");
        JPanel container = new JPanel(new BorderLayout());
        container.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 4));
        this.bar.setMinimum(0);
        this.bar.setMaximum(this.progress.getMaxIterations());
        this.bar.setPreferredSize(new Dimension(200, 16));
        this.bar.setStringPainted(true);
        container.add(this.bar);
        this.panel.add((Component)container, "East");
        this.time = System.nanoTime();
        this.update("", "init");
    }

    protected void update(final String message, final String progressMessage) {
        this.task.execute(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String pm = progressMessage;
                        if (pm == null) {
                            pm = (this).StatusBar.this.progress.getCurrentIteration() + "/" + (this).StatusBar.this.progress.getMaxIterations();
                        }
                        (this).StatusBar.this.label.setText(" " + message);
                        (this).StatusBar.this.bar.setValue((this).StatusBar.this.progress.getCurrentIteration());
                        (this).StatusBar.this.bar.setString(pm);
                    }
                });
            }
        });
    }

    public JComponent get() {
        return this.panel;
    }

    @Override
    public void iterationComplete(Optimizer optimizer, int iteration) {
        long diff = Math.round((double)(System.nanoTime() - this.time) / 1000000.0);
        this.time = System.nanoTime();
        DecimalFormat format = new DecimalFormat();
        this.update(format.format(diff), null);
    }

    @Override
    public void optimizationStarted(Optimizer optimizer) {
    }

    @Override
    public void optimizationStopped(Optimizer optimizer) {
        this.update("", "done");
        this.timeLabel.setText("");
    }
}

