/*
 * Decompiled with CFR 0.152.
 */
package org.opt4j.viewer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;
import org.opt4j.config.Icons;
import org.opt4j.viewer.ArchiveWidget;
import org.opt4j.viewer.ConvergencePlotWidget;
import org.opt4j.viewer.ParetoPlotWidget;
import org.opt4j.viewer.PopulationWidget;
import org.opt4j.viewer.ToolBarOrder;
import org.opt4j.viewer.ToolBarService;
import org.opt4j.viewer.Viewport;
import org.opt4j.viewer.Widget;

@ToolBarOrder(value=-50)
public class ViewsToolBarService
implements ToolBarService {
    protected final Viewport viewport;
    protected final Provider<ArchiveWidget> archiveWidgetProvider;
    protected final Provider<PopulationWidget> populationWidgetProvider;
    protected final Provider<ParetoPlotWidget> plotWidgetProvider;
    protected final Provider<ConvergencePlotWidget> objectivesPlotWidgetProvider;
    protected ArchiveWidget archiveWidget = null;
    protected PopulationWidget populationWidget = null;

    @Inject
    public ViewsToolBarService(Viewport viewport, Provider<ArchiveWidget> archiveWidgetProvider, Provider<PopulationWidget> populationWidgetProvider, Provider<ParetoPlotWidget> plotWidgetProvider, Provider<ConvergencePlotWidget> objectivesPlotWidgetProvider) {
        this.viewport = viewport;
        this.archiveWidgetProvider = archiveWidgetProvider;
        this.populationWidgetProvider = populationWidgetProvider;
        this.plotWidgetProvider = plotWidgetProvider;
        this.objectivesPlotWidgetProvider = objectivesPlotWidgetProvider;
    }

    @Override
    public JToolBar getToolBar() {
        JToolBar toolbar = new JToolBar("Views");
        JButton buttonArchive = new JButton(Icons.getIcon("icons/user-green.png"));
        buttonArchive.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ArchiveWidget widget = ViewsToolBarService.this.getArchiveWidget();
                ViewsToolBarService.this.viewport.addWidget(widget);
            }
        });
        buttonArchive.setToolTipText("Archive");
        buttonArchive.setFocusable(false);
        JButton buttonPopulation = new JButton(Icons.getIcon("icons/user-blue.png"));
        buttonPopulation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PopulationWidget widget = ViewsToolBarService.this.getPopulationWidget();
                ViewsToolBarService.this.viewport.addWidget(widget);
            }
        });
        buttonPopulation.setToolTipText("Population");
        buttonPopulation.setFocusable(false);
        JButton buttonPlot = new JButton(Icons.getIcon("icons/stat.png"));
        buttonPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ParetoPlotWidget widget = ViewsToolBarService.this.getPlotWidget();
                ViewsToolBarService.this.viewport.addWidget(widget);
            }
        });
        buttonPlot.setToolTipText("Pareto Plot");
        buttonPlot.setFocusable(false);
        JButton buttonObjectivesPlot = new JButton(Icons.getIcon("icons/convergence.png"));
        buttonObjectivesPlot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Widget widget = (Widget)ViewsToolBarService.this.objectivesPlotWidgetProvider.get();
                ViewsToolBarService.this.viewport.addWidget(widget);
            }
        });
        buttonObjectivesPlot.setToolTipText("Objectives Plot");
        buttonObjectivesPlot.setFocusable(false);
        toolbar.add(buttonArchive);
        toolbar.add(buttonPopulation);
        toolbar.add(buttonPlot);
        toolbar.add(buttonObjectivesPlot);
        return toolbar;
    }

    protected ArchiveWidget getArchiveWidget() {
        if (this.archiveWidget == null) {
            this.archiveWidget = (ArchiveWidget)this.archiveWidgetProvider.get();
        }
        return this.archiveWidget;
    }

    protected PopulationWidget getPopulationWidget() {
        if (this.populationWidget == null) {
            this.populationWidget = (PopulationWidget)this.populationWidgetProvider.get();
        }
        return this.populationWidget;
    }

    protected ParetoPlotWidget getPlotWidget() {
        return (ParetoPlotWidget)this.plotWidgetProvider.get();
    }
}

