/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.xtext.utils.gmf.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.BaseSlidableAnchor;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.gef.ui.figures.SlidableAnchor;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;

public class AdjustIdentityAnchorCommand
extends AbstractTransactionalCommand {
    private static final char TERMINAL_START_CHAR = '(';
    private static final char TERMINAL_DELIMITER_CHAR = ',';
    private static final char TERMINAL_END_CHAR = ')';
    private static final PrecisionPoint DEFAULT_POINT = new PrecisionPoint(0.5, 0.5);
    private ChangeBoundsRequest request;
    private Dimension futureSize;
    private PrecisionPoint delta;

    public AdjustIdentityAnchorCommand(TransactionalEditingDomain domain, ChangeBoundsRequest request) {
        super(domain, "Adjusting anchors", null);
        this.request = request;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        List editParts = this.request.getEditParts();
        for (IGraphicalEditPart editPart : editParts) {
            this.adjustAnchors(editPart);
        }
        return CommandResult.newOKCommandResult();
    }

    protected void adjustAnchors(IGraphicalEditPart editPart) {
        if (editPart instanceof IGraphicalEditPart) {
            View view = editPart.getNotationView();
            EList targetEdges = view.getTargetEdges();
            for (Edge edge : targetEdges) {
                this.handleEdge(edge, (EditPart)editPart, false);
            }
            EList sourceEdges = view.getSourceEdges();
            for (Edge edge : sourceEdges) {
                this.handleEdge(edge, (EditPart)editPart, true);
            }
        }
    }

    private void handleEdge(Edge edge, EditPart editPart, boolean sourceAnchor) {
        Anchor anchorToModify = sourceAnchor ? edge.getSourceAnchor() : edge.getTargetAnchor();
        String terminalString = this.composeTerminalString(DEFAULT_POINT);
        if (anchorToModify instanceof IdentityAnchor) {
            terminalString = ((IdentityAnchor)anchorToModify).getId();
        }
        PrecisionPoint anchorPoint = BaseSlidableAnchor.parseTerminalString((String)terminalString);
        PrecisionPoint newPoint = this.computeNewAnchor(anchorPoint, editPart);
        String newTerminalString = new SlidableAnchor(null, newPoint).getTerminal();
        if (anchorToModify instanceof IdentityAnchor) {
            ((IdentityAnchor)anchorToModify).setId(newTerminalString);
        } else if (anchorToModify == null) {
            IdentityAnchor newAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
            newAnchor.setId(newTerminalString);
            if (sourceAnchor) {
                edge.setSourceAnchor((Anchor)newAnchor);
            } else {
                edge.setTargetAnchor((Anchor)newAnchor);
            }
        }
    }

    protected double getScale(EditPart part) {
        double scale = 1.0;
        if (part.getRoot() instanceof DiagramRootEditPart) {
            DiagramRootEditPart rootEditPart = (DiagramRootEditPart)part.getRoot();
            scale = rootEditPart.getZoomManager().getZoom();
        }
        return scale;
    }

    private PrecisionPoint computeNewAnchor(PrecisionPoint currentAnchorPoint, EditPart editPart) {
        double scale = this.getScale(editPart);
        IFigure figure = ((IGraphicalEditPart)editPart).getFigure();
        Rectangle bounds = figure.getBounds();
        if (figure instanceof HandleBounds) {
            bounds = ((HandleBounds)figure).getHandleBounds();
        }
        Point currentRelativePoint = this.getAnchorRelativePoint(currentAnchorPoint, bounds);
        if (this.futureSize != null && this.delta != null) {
            return new PrecisionPoint((double)(currentRelativePoint.x - this.delta.x) / (double)this.futureSize.width, (double)(currentRelativePoint.y - this.delta.y) / (double)this.futureSize.height);
        }
        double logicalWidthDelta = (double)this.request.getSizeDelta().width / scale;
        double logicalHeightDelta = (double)this.request.getSizeDelta().height / scale;
        int direction = this.request.getResizeDirection();
        double newRelativeX = this.computeNewXRelativeLocation(direction, currentRelativePoint, logicalWidthDelta);
        double newRelativeY = this.computeNewYRelativeLocation(direction, currentRelativePoint, logicalHeightDelta);
        return new PrecisionPoint(newRelativeX / ((double)bounds.width() + logicalWidthDelta), newRelativeY / ((double)bounds.height() + logicalHeightDelta));
    }

    protected Point getAnchorRelativePoint(PrecisionPoint currentAnchorPoint, Rectangle bounds) {
        return new PrecisionPoint((double)bounds.width() * currentAnchorPoint.preciseX(), (double)bounds.height() * currentAnchorPoint.preciseY());
    }

    private double computeNewXRelativeLocation(int direction, Point currentRelativePoint, double logicalWidthDelta) {
        if (direction == 9 || direction == 8 || direction == 12) {
            return currentRelativePoint.preciseX() + logicalWidthDelta;
        }
        return currentRelativePoint.preciseX();
    }

    protected double computeNewYRelativeLocation(int direction, Point currentRelativePoint, double logicalHeightDelta) {
        if (direction == 9 || direction == 1 || direction == 17) {
            return currentRelativePoint.preciseY() + logicalHeightDelta;
        }
        return currentRelativePoint.preciseY();
    }

    protected String composeTerminalString(PrecisionPoint p) {
        StringBuffer s = new StringBuffer(24);
        s.append('(');
        s.append(p.preciseX());
        s.append(',');
        s.append(p.preciseY());
        s.append(')');
        return s.toString();
    }
}

