/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.xtext.utils.gmf.directedit;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.TextDirectEditManager;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.ShapeStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;
import org.yakindu.base.xtext.utils.gmf.directedit.DoubleClickDirectEditDragTracker;
import org.yakindu.base.xtext.utils.gmf.directedit.IXtextAwareEditPart;
import org.yakindu.base.xtext.utils.gmf.directedit.XtextDirectEditManager;
import org.yakindu.base.xtext.utils.gmf.figures.SyntaxColoringLabel;
import org.yakindu.base.xtext.utils.jface.viewers.XtextStyledTextCellEditor;

public abstract class XtextLabelEditPart
extends CompartmentEditPart
implements IXtextAwareEditPart {
    protected abstract DirectEditManager createDirectEditManager();

    protected abstract void setLabelStyles(String var1);

    protected abstract void setContext(Resource var1);

    public XtextLabelEditPart(View view) {
        super((EObject)view);
    }

    protected SyntaxColoringLabel createFigure() {
        SyntaxColoringLabel label = new SyntaxColoringLabel();
        label.setTextWrap(true);
        label.setAlignment(9);
        return label;
    }

    public SyntaxColoringLabel getFigure() {
        return (SyntaxColoringLabel)super.getFigure();
    }

    @Override
    public void setLabelText(String text) {
        if (text != null && !text.equals(this.getFigure().getText())) {
            this.setLabelStyles(text);
            this.getFigure().setText(text);
        }
    }

    protected void refreshVisuals() {
        this.setLabelStyles(this.getEditText());
        super.refreshVisuals();
        this.refreshFont();
        this.refreshFontColor();
        this.updateLabelText();
    }

    protected void updateLabelText() {
        this.getFigure().setText(this.getEditText());
    }

    protected void setFontColor(Color color) {
        this.getFigure().setForegroundColor(color);
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getNotifier() instanceof ShapeStyle) {
            this.refreshVisuals();
        } else if (NotationPackage.eINSTANCE.getFontStyle().getEAllAttributes().contains(notification.getFeature())) {
            this.refreshFont();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    public DragTracker getDragTracker(final Request request) {
        if (request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3) {
            return null;
        }
        DoubleClickDirectEditDragTracker.IDoubleClickCallback callback = new DoubleClickDirectEditDragTracker.IDoubleClickCallback(){

            @Override
            public void handleDoubleClick(int btn) {
                XtextLabelEditPart.this.performDirectEditRequest(request);
            }
        };
        return new DoubleClickDirectEditDragTracker((EditPart)this, (EditPart)this.getTopGraphicEditPart(), callback);
    }

    public void performDirectEditRequest(Request request) {
        final DirectEditManager manager = this.createDirectEditManager();
        final Request theRequest = request;
        try {
            this.getEditingDomain().runExclusive(new Runnable(){

                @Override
                public void run() {
                    if (XtextLabelEditPart.this.isActive()) {
                        if (theRequest.getExtendedData().get("directedit_extendeddata_initial_char") instanceof Character) {
                            Character initialChar = (Character)theRequest.getExtendedData().get("directedit_extendeddata_initial_char");
                            if (manager instanceof XtextDirectEditManager) {
                                XtextDirectEditManager xtextDirectEditManager = (XtextDirectEditManager)manager;
                                xtextDirectEditManager.show(initialChar.charValue());
                            } else if (manager instanceof TextDirectEditManager) {
                                ((TextDirectEditManager)manager).show(initialChar.charValue());
                            }
                        } else {
                            manager.show();
                        }
                        if (manager instanceof XtextDirectEditManager) {
                            XtextDirectEditManager xtextDirectEditManager = (XtextDirectEditManager)manager;
                            XtextStyledTextCellEditor cellEditor = (XtextStyledTextCellEditor)xtextDirectEditManager.getCellEditor();
                            XtextLabelEditPart.this.setContext((Resource)cellEditor.getXtextAdapter().getFakeResourceContext().getFakeResource());
                        }
                    }
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

