/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.xtext.utils.jface.viewers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.swt.IFocusService;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.editor.validation.AnnotationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.util.concurrent.IReadAccess;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;
import org.yakindu.base.xtext.utils.jface.fieldassist.CompletionProposalAdapter;
import org.yakindu.base.xtext.utils.jface.viewers.XtextSourceViewerEx;
import org.yakindu.base.xtext.utils.jface.viewers.XtextStyledTextCellEditor;
import org.yakindu.base.xtext.utils.jface.viewers.XtextStyledTextHighlightingHelper;
import org.yakindu.base.xtext.utils.jface.viewers.XtextStyledTextSelectionProvider;
import org.yakindu.base.xtext.utils.jface.viewers.context.IXtextFakeContextResourcesProvider;
import org.yakindu.base.xtext.utils.jface.viewers.context.XtextFakeResourceContext;

public class StyledTextXtextAdapter {
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccess;
    @Inject
    private ICharacterPairMatcher characterPairMatcher;
    @Inject
    private XtextSourceViewerConfiguration configuration;
    @Inject
    private XtextStyledTextHighlightingHelper xtextStyledTextHighlightingHelper;
    @Inject
    private IResourceValidator validator;
    @Inject
    private Provider<IDocumentPartitioner> documentPartitioner;
    @Inject
    private XtextDocument document;
    private final IssueResolutionProvider resolutionProvider = new IssueResolutionProvider.NullImpl();
    private final IXtextFakeContextResourcesProvider contextFakeResourceProvider;
    private final XtextFakeResourceContext fakeResourceContext;
    private XtextSourceViewer sourceviewer;
    private ValidationJob validationJob;
    private StyledText styledText;
    private ControlDecoration decoration;
    private SourceViewerDecorationSupport decorationSupport;
    private IWorkbenchPartSite site;

    public StyledTextXtextAdapter(Injector injector, IXtextFakeContextResourcesProvider contextFakeResourceProvider) {
        this.contextFakeResourceProvider = contextFakeResourceProvider;
        injector.injectMembers((Object)this);
        this.fakeResourceContext = this.createFakeResourceContext(injector);
    }

    public StyledTextXtextAdapter(Injector injector) {
        this(injector, IXtextFakeContextResourcesProvider.NULL_CONTEXT_PROVIDER);
    }

    public StyledTextXtextAdapter(Injector inject, IWorkbenchPartSite site) {
        this(inject);
        this.site = site;
    }

    public void adapt(StyledText styledText) {
        this.styledText = styledText;
        this.updateFakeResourceContext();
        this.initXtextDocument(this.getFakeResourceContext());
        this.sourceviewer = this.createXtextSourceViewer();
        this.decorationSupport = this.createSourceViewerDecorationSupport();
        this.configureSourceViewerDecorationSupport(this.getDecorationSupport());
        this.installHighlightingHelper();
        this.validationJob = this.createValidationJob();
        this.getXtextDocument().setValidationJob((Job)this.getValidationJob());
        styledText.setData(StyledTextXtextAdapter.class.getCanonicalName(), (Object)this);
        IContentAssistant contentAssistant = this.getXtextSourceviewer().getContentAssistant();
        final CompletionProposalAdapter completionProposalAdapter = new CompletionProposalAdapter((Control)styledText, contentAssistant, KeyStroke.getInstance((int)262144, (int)32), null);
        if ((styledText.getStyle() & 4) != 0) {
            styledText.addListener(3005, new Listener(){

                public void handleEvent(Event event) {
                    if (event.character == '\r' && !completionProposalAdapter.isProposalPopupOpen()) {
                        Event selectionEvent = new Event();
                        selectionEvent.type = 14;
                        selectionEvent.widget = event.widget;
                        Listener[] listenerArray = event.widget.getListeners(14);
                        int n = listenerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Listener l = listenerArray[n2];
                            l.handleEvent(selectionEvent);
                            ++n2;
                        }
                    }
                }
            });
        }
        IFocusService service = (IFocusService)PlatformUI.getWorkbench().getService(IFocusService.class);
        service.addFocusTracker((Control)styledText, StyledText.class.getCanonicalName());
        this.decoration = this.createContentAssistDecoration(styledText);
        this.initSelectionProvider();
    }

    protected void initSelectionProvider() {
        try {
            if (this.site == null) {
                this.site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getSite();
            }
            XtextStyledTextSelectionProvider xtextStyledTextSelectionProvider = new XtextStyledTextSelectionProvider(this.styledText, this.getFakeResourceContext().getFakeResource());
            ChangeSelectionProviderOnFocusGain listener = new ChangeSelectionProviderOnFocusGain(this.site, xtextStyledTextSelectionProvider, this.styledText);
            this.getStyledText().addFocusListener((FocusListener)listener);
            this.getStyledText().addDisposeListener((DisposeListener)listener);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private ControlDecoration createContentAssistDecoration(StyledText styledText) {
        ControlDecoration result = new ControlDecoration((Control)styledText, 16512);
        result.setShowHover(true);
        result.setShowOnlyOnFocus(true);
        final Image image = ImageDescriptor.createFromFile(XtextStyledTextCellEditor.class, (String)"images/content_assist_cue.gif").createImage();
        result.setImage(image);
        result.setDescriptionText("Content Assist Available (CTRL + Space)");
        result.setMarginWidth(2);
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (StyledTextXtextAdapter.this.getDecoration() != null) {
                    StyledTextXtextAdapter.this.getDecoration().dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
        });
        return result;
    }

    protected ValidationJob createValidationJob() {
        return new ValidationJob(this.getValidator(), (IReadAccess)this.getXtextDocument(), (IValidationIssueProcessor)new AnnotationIssueProcessor((IXtextDocument)this.getXtextDocument(), this.getXtextSourceviewer().getAnnotationModel(), this.getResolutionProvider()), CheckMode.FAST_ONLY);
    }

    protected XtextFakeResourceContext createFakeResourceContext(Injector injector) {
        return new XtextFakeResourceContext(injector);
    }

    protected XtextSourceViewer createXtextSourceViewer() {
        XtextSourceViewerEx result = new XtextSourceViewerEx(this.getStyledText(), this.getPreferenceStoreAccess().getPreferenceStore());
        result.configure((SourceViewerConfiguration)this.getXtextSourceViewerConfiguration());
        result.setDocument((IDocument)this.getXtextDocument(), (IAnnotationModel)new AnnotationModel());
        return result;
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsPlugin.getDefault().getSharedTextColors();
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        MarkerAnnotationPreferences annotationPreferences = new MarkerAnnotationPreferences();
        List prefs = annotationPreferences.getAnnotationPreferences();
        for (AnnotationPreference annotationPreference : prefs) {
            support.setAnnotationPreference(annotationPreference);
        }
        support.setCharacterPairMatcher(this.getCharacterPairMatcher());
        support.setMatchingCharacterPainterPreferenceKeys("CharacterMatching", "CharacterMatching.Color");
        support.install(this.getPreferenceStoreAccess().getPreferenceStore());
    }

    protected void unconfigureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        support.uninstall();
    }

    protected void initXtextDocument(XtextFakeResourceContext context) {
        this.getXtextDocument().setInput(context.getFakeResource());
        IDocumentPartitioner partitioner = (IDocumentPartitioner)this.getDocumentPartitioner().get();
        partitioner.connect((IDocument)this.getXtextDocument());
        this.getXtextDocument().setDocumentPartitioner(partitioner);
    }

    public void setVisibleRegion(int start, int length) {
        this.getXtextSourceviewer().setVisibleRegion(start, length);
    }

    public void resetVisibleRegion() {
        this.getXtextSourceviewer().resetVisibleRegion();
    }

    private void installHighlightingHelper() {
        if (this.getXtextStyledTextHighlightingHelper() != null) {
            this.getXtextStyledTextHighlightingHelper().install(this, this.getXtextSourceviewer());
        }
    }

    private void uninstallHighlightingHelper() {
        if (this.getXtextStyledTextHighlightingHelper() != null) {
            this.getXtextStyledTextHighlightingHelper().uninstall();
        }
    }

    public void dispose() {
        this.getXtextDocument().setOutdated(true);
        if (this.getDecorationSupport() != null) {
            this.unconfigureSourceViewerDecorationSupport(this.getDecorationSupport());
        }
        this.uninstallHighlightingHelper();
    }

    protected XtextSourceViewerConfiguration getXtextSourceViewerConfiguration() {
        return this.configuration;
    }

    protected XtextDocument getXtextDocument() {
        return this.document;
    }

    protected XtextSourceViewer getXtextSourceviewer() {
        return this.sourceviewer;
    }

    public IParseResult getXtextParseResult() {
        return (IParseResult)this.getXtextDocument().readOnly((IUnitOfWork)new IUnitOfWork<IParseResult, XtextResource>(){

            public IParseResult exec(XtextResource state) throws Exception {
                return state.getParseResult();
            }
        });
    }

    public IContentAssistant getContentAssistant() {
        return this.getXtextSourceviewer().getContentAssistant();
    }

    public List<Issue> getXtextValidationIssues() {
        return this.getValidationJob().createIssues((IProgressMonitor)new NullProgressMonitor());
    }

    public void updateFakeResourceContext() {
        this.getFakeResourceContext().updateFakeResourceContext(this.getFakeResourceContextProvider());
    }

    protected IXtextFakeContextResourcesProvider getFakeResourceContextProvider() {
        return this.contextFakeResourceProvider;
    }

    public XtextFakeResourceContext getFakeResourceContext() {
        return this.fakeResourceContext;
    }

    protected SourceViewerDecorationSupport createSourceViewerDecorationSupport() {
        return new SourceViewerDecorationSupport((ISourceViewer)this.getXtextSourceviewer(), null, (IAnnotationAccess)new DefaultMarkerAnnotationAccess(), this.getSharedColors());
    }

    protected ValidationJob getValidationJob() {
        return this.validationJob;
    }

    protected IssueResolutionProvider getResolutionProvider() {
        return this.resolutionProvider;
    }

    protected StyledText getStyledText() {
        return this.styledText;
    }

    protected ControlDecoration getDecoration() {
        return this.decoration;
    }

    protected SourceViewerDecorationSupport getDecorationSupport() {
        return this.decorationSupport;
    }

    protected IResourceValidator getValidator() {
        return this.validator;
    }

    protected IPreferenceStoreAccess getPreferenceStoreAccess() {
        return this.preferenceStoreAccess;
    }

    protected ICharacterPairMatcher getCharacterPairMatcher() {
        return this.characterPairMatcher;
    }

    protected Provider<IDocumentPartitioner> getDocumentPartitioner() {
        return this.documentPartitioner;
    }

    protected XtextStyledTextHighlightingHelper getXtextStyledTextHighlightingHelper() {
        return this.xtextStyledTextHighlightingHelper;
    }

    public static class ChangeSelectionProviderOnFocusGain
    implements FocusListener,
    DisposeListener {
        protected ISelectionProvider selectionProviderOnFocusGain;
        protected ISelectionProvider selectionProviderOnFocusLost;
        protected IWorkbenchPartSite site;
        private boolean ignoreNextFocusLost = false;
        private StyledText text;

        public ChangeSelectionProviderOnFocusGain(IWorkbenchPartSite site, ISelectionProvider selectionProviderOnFocusGain, StyledText text) {
            this.selectionProviderOnFocusGain = selectionProviderOnFocusGain;
            this.site = site;
            this.text = text;
        }

        public void focusLost(FocusEvent e) {
            if (SWT.getPlatform().equals("gtk")) {
                if (this.isIgnoreNextFocusLost()) {
                    this.setIgnoreNextFocusLost(false);
                    return;
                }
                if (this.text.getMenu().isVisible()) {
                    this.setIgnoreNextFocusLost(true);
                    return;
                }
            }
            if (this.selectionProviderOnFocusLost != null) {
                this.site.setSelectionProvider(this.selectionProviderOnFocusLost);
            }
            this.text.setSelection(this.text.getCaretOffset());
        }

        protected void setIgnoreNextFocusLost(boolean b) {
            this.ignoreNextFocusLost = b;
        }

        protected boolean isIgnoreNextFocusLost() {
            return this.ignoreNextFocusLost;
        }

        public void focusGained(FocusEvent e) {
            this.selectionProviderOnFocusLost = this.site.getSelectionProvider();
            this.site.setSelectionProvider(this.selectionProviderOnFocusGain);
        }

        public void widgetDisposed(DisposeEvent e) {
            if (this.selectionProviderOnFocusLost != null) {
                this.site.setSelectionProvider(this.selectionProviderOnFocusLost);
            }
            ((StyledText)e.getSource()).removeFocusListener((FocusListener)this);
            ((StyledText)e.getSource()).removeDisposeListener((DisposeListener)this);
        }
    }
}

