/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.base.utils.jface.help;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.context.ContextFileProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;

public abstract class AbstractUserHelpDocumentationProvider
implements IEObjectDocumentationProvider {
    public static final String EMPTY_DOCUMENTATION = "";
    private Map<String, String> helpContentCache = Maps.newHashMap();

    protected String getHelp(String contextId) {
        if (this.helpContentCache.get(contextId) != null) {
            return this.helpContentCache.get(contextId);
        }
        try {
            this.helpContentCache.put(contextId, this.parseHelp(contextId));
        }
        catch (Exception e) {
            e.printStackTrace();
            this.helpContentCache.put(contextId, EMPTY_DOCUMENTATION);
        }
        return this.helpContentCache.get(contextId);
    }

    private String parseHelp(String contextId) throws Exception {
        ContextFileProvider provider = new ContextFileProvider();
        IContext context = provider.getContext(contextId, Locale.getDefault().toString());
        IHelpResource[] relatedTopics = context.getRelatedTopics();
        Assert.isTrue((relatedTopics != null ? 1 : 0) != 0);
        IHelpResource helpResource = relatedTopics[0];
        String href = helpResource.getHref().substring(1);
        URL url = new URL("platform:/plugin/" + href);
        return this.convertStreamToString(url.openConnection().getInputStream());
    }

    public String convertStreamToString(InputStream is) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String ret = reader.lines().collect(Collectors.joining("\n"));
        is.close();
        reader.close();
        return ret;
    }
}

