/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class TableColumn
extends Item {
    Table parent;
    NSTableColumn nsColumn;
    String toolTipText;
    String displayText;
    boolean movable;
    static final int MARGIN = 2;

    public TableColumn(Table parent, int style) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.columnCount);
    }

    public TableColumn(Table parent, int style, int index) {
        super(parent, TableColumn.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Widget.checkBits(style, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.nsColumn.headerCell());
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    void drawInteriorWithFrame_inView(int id2, int sel, NSRect cellRect, int view) {
        NSRect destRect;
        int columnIndex = this.parent.indexOf(this.nsColumn);
        NSRect headerRect = this.parent.headerView.headerRectOfColumn(columnIndex);
        if (headerRect.x != cellRect.x || headerRect.width != cellRect.width) {
            return;
        }
        NSGraphicsContext context = NSGraphicsContext.currentContext();
        context.saveGraphicsState();
        int contentWidth = 0;
        NSSize stringSize = null;
        NSSize imageSize = null;
        NSAttributedString attrString = null;
        NSTableHeaderCell headerCell = this.nsColumn.headerCell();
        if (this.displayText != null) {
            Font font = Font.cocoa_new(this.display, headerCell.font());
            attrString = this.parent.createString(this.displayText, font, null, 16384, false, (this.parent.state & 8) == 0, false);
            stringSize = attrString.size();
            contentWidth = (int)((double)contentWidth + Math.ceil(stringSize.width));
            if (this.image != null) {
                contentWidth += 2;
            }
        }
        if (this.image != null) {
            imageSize = this.image.handle.size();
            contentWidth = (int)((double)contentWidth + Math.ceil(imageSize.width));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            boolean ascending = this.parent.sortDirection == 128;
            headerCell.drawSortIndicatorWithFrame(cellRect, new NSView(view), ascending, 0);
            NSRect sortRect = headerCell.sortIndicatorRectForBounds(cellRect);
            cellRect.width = Math.max(0.0f, sortRect.x - cellRect.x);
        }
        int drawX = 0;
        drawX = (this.style & 0x1000000) != 0 ? (int)(cellRect.x + Math.max(2.0f, (cellRect.width - (float)contentWidth) / 2.0f)) : ((this.style & 0x20000) != 0 ? (int)(cellRect.x + Math.max(2.0f, cellRect.width - (float)contentWidth - 2.0f)) : (int)cellRect.x + 2);
        if (this.image != null) {
            destRect = new NSRect();
            destRect.x = drawX;
            destRect.y = Math.max(cellRect.y, cellRect.y + (cellRect.height - imageSize.height) / 2.0f);
            destRect.width = Math.min(imageSize.width, cellRect.width - 4.0f);
            destRect.height = Math.min(imageSize.height, cellRect.height);
            boolean isFlipped = new NSView(view).isFlipped();
            if (isFlipped) {
                context.saveGraphicsState();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.scaleXBy(1.0f, -1.0f);
                transform.translateXBy(0.0f, -(destRect.height + 2.0f * destRect.y));
                transform.concat();
            }
            NSRect sourceRect = new NSRect();
            sourceRect.width = destRect.width;
            sourceRect.height = destRect.height;
            this.image.handle.drawInRect(destRect, sourceRect, 2, 1.0f);
            if (isFlipped) {
                context.restoreGraphicsState();
            }
            drawX = (int)((float)drawX + destRect.width);
        }
        if (this.displayText != null && this.displayText.length() > 0) {
            if (this.image != null) {
                drawX += 2;
            }
            destRect = new NSRect();
            destRect.x = drawX;
            destRect.y = cellRect.y;
            destRect.width = Math.min(stringSize.width, cellRect.x + cellRect.width - 2.0f - (float)drawX);
            destRect.height = Math.min(stringSize.height, cellRect.height);
            attrString.drawInRect(destRect);
        }
        if (attrString != null) {
            attrString.release();
        }
        context.restoreGraphicsState();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    String getNameText() {
        return this.getText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return this.movable;
    }

    public boolean getResizable() {
        this.checkWidget();
        return this.nsColumn.resizingMask() != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int width = (int)this.nsColumn.width();
        if (width > 0) {
            ++width;
        }
        return width;
    }

    public void pack() {
        this.checkWidget();
        int width = 0;
        NSTableHeaderCell headerCell = this.nsColumn.headerCell();
        NSSize size = headerCell.cellSize();
        width = (int)((double)width + Math.ceil(size.width));
        if (this.image != null) {
            NSSize imageSize = this.image.handle.size();
            width = (int)((double)width + (Math.ceil(imageSize.width) + 2.0));
        }
        if (this.parent.sortColumn == this && this.parent.sortDirection != 0) {
            NSRect sortRect = headerCell.sortIndicatorRectForBounds(new NSRect());
            width = (int)((double)width + Math.ceil(sortRect.width + 4.0f));
        }
        GC gc = new GC(this.parent);
        int index = this.parent.indexOf(this);
        width = Math.max(width, this.parent.calculateWidth(this.parent.items, index, gc));
        gc.dispose();
        this.setWidth(width);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.nsColumn != null) {
            this.nsColumn.headerCell().release();
            this.nsColumn.release();
        }
        this.nsColumn = null;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAlignment(int alignment) {
        this.checkWidget();
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        int index = this.parent.indexOf(this);
        if (index == -1 || index == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        NSTableView tableView = (NSTableView)this.parent.view;
        NSTableHeaderView headerView = tableView.headerView();
        if (headerView == null) {
            return;
        }
        index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
        rect = tableView.rectOfColumn(index);
        this.parent.view.setNeedsDisplayInRect(rect);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        NSTableHeaderView headerView = ((NSTableView)this.parent.view).headerView();
        if (headerView == null) {
            return;
        }
        int index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
    }

    public void setMoveable(boolean moveable) {
        this.checkWidget();
        this.movable = moveable;
    }

    public void setResizable(boolean resizable) {
        this.checkWidget();
        this.nsColumn.setResizingMask(resizable ? 2 : 0);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] buffer = new char[this.text.length()];
        this.text.getChars(0, buffer.length, buffer, 0);
        int length = this.fixMnemonic(buffer);
        this.displayText = new String(buffer, 0, length);
        NSString title = NSString.stringWith(this.displayText);
        this.nsColumn.headerCell().setTitle(title);
        NSTableHeaderView headerView = ((NSTableView)this.parent.view).headerView();
        if (headerView == null) {
            return;
        }
        int index = this.parent.indexOf(this.nsColumn);
        NSRect rect = headerView.headerRectOfColumn(index);
        headerView.setNeedsDisplayInRect(rect);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.parent.checkToolTip(this);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if (width < 0) {
            return;
        }
        width = Math.max(0, width - 1);
        this.nsColumn.setWidth(width);
    }

    String tooltipText() {
        return this.toolTipText;
    }
}

