/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TableDropTargetEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDropTargetEffect;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkDragContext;
import org.eclipse.swt.internal.gtk.GtkSelectionData;
import org.eclipse.swt.internal.gtk.GtkTargetEntry;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DropTarget
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DropTargetEffect dropEffect;
    TransferData selectedDataType;
    int selectedOperation;
    int keyOperation = -1;
    long dragOverStart;
    Runnable dragOverHeartbeat;
    DNDEvent dragOverEvent;
    int drag_motion_handler;
    int drag_leave_handler;
    int drag_data_received_handler;
    int drag_drop_handler;
    static final String DEFAULT_DROP_TARGET_EFFECT = "DEFAULT_DROP_TARGET_EFFECT";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.control.isactive";
    static final int DRAGOVER_HYSTERESIS = 50;
    static Callback Drag_Motion;
    static Callback Drag_Leave;
    static Callback Drag_Data_Received;
    static Callback Drag_Drop;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4 = class$0;
        if (clazz4 == null) {
            try {
                clazz4 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Motion = new Callback(clazz4, "Drag_Motion", 5)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz3 = class$0) == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Leave = new Callback(clazz3, "Drag_Leave", 3)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz2 = class$0) == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Data_Received = new Callback(clazz2, "Drag_Data_Received", 7)).getAddress() == 0) {
            SWT.error(3);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((Drag_Drop = new Callback(clazz, "Drag_Drop", 5)).getAddress() == 0) {
            SWT.error(3);
        }
    }

    public DropTarget(Control control, int style) {
        super(control, DropTarget.checkStyle(style));
        this.control = control;
        if (Drag_Motion == null || Drag_Leave == null || Drag_Data_Received == null || Drag_Drop == null) {
            DND.error(2001);
        }
        if (control.getData("DropTarget") != null) {
            DND.error(2001);
        }
        control.setData("DropTarget", this);
        this.drag_motion_handler = OS.g_signal_connect(control.handle, OS.drag_motion, Drag_Motion.getAddress(), 0);
        this.drag_leave_handler = OS.g_signal_connect(control.handle, OS.drag_leave, Drag_Leave.getAddress(), 0);
        this.drag_data_received_handler = OS.g_signal_connect(control.handle, OS.drag_data_received, Drag_Data_Received.getAddress(), 0);
        this.drag_drop_handler = OS.g_signal_connect(control.handle, OS.drag_drop, Drag_Drop.getAddress(), 0);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (!DropTarget.this.isDisposed()) {
                    DropTarget.this.dispose();
                }
            }
        };
        control.addListener(12, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DropTarget.this.onDispose();
            }
        });
        Object effect = control.getData(DEFAULT_DROP_TARGET_EFFECT);
        if (effect instanceof DropTargetEffect) {
            this.dropEffect = (DropTargetEffect)effect;
        } else if (control instanceof Table) {
            this.dropEffect = new TableDropTargetEffect((Table)control);
        } else if (control instanceof Tree) {
            this.dropEffect = new TreeDropTargetEffect((Tree)control);
        }
        this.dragOverHeartbeat = new Runnable(){

            public void run() {
                Control control = DropTarget.this.control;
                if (control == null || control.isDisposed() || DropTarget.this.dragOverStart == 0L) {
                    return;
                }
                long time = System.currentTimeMillis();
                int delay = 50;
                if (time < DropTarget.this.dragOverStart) {
                    delay = (int)(DropTarget.this.dragOverStart - time);
                } else {
                    DropTarget.this.dragOverEvent.time += 50;
                    int allowedOperations = DropTarget.this.dragOverEvent.operations;
                    TransferData[] allowedTypes = DropTarget.this.dragOverEvent.dataTypes;
                    TransferData[] dataTypes = new TransferData[allowedTypes.length];
                    System.arraycopy(allowedTypes, 0, dataTypes, 0, dataTypes.length);
                    DNDEvent event = new DNDEvent();
                    event.widget = DropTarget.this.dragOverEvent.widget;
                    event.x = DropTarget.this.dragOverEvent.x;
                    event.y = DropTarget.this.dragOverEvent.y;
                    event.time = DropTarget.this.dragOverEvent.time;
                    event.feedback = 1;
                    event.dataTypes = dataTypes;
                    event.dataType = DropTarget.this.selectedDataType;
                    event.operations = DropTarget.this.dragOverEvent.operations;
                    event.detail = DropTarget.this.selectedOperation;
                    if (DropTarget.this.dropEffect != null) {
                        event.item = DropTarget.this.dropEffect.getItem(DropTarget.this.dragOverEvent.x, DropTarget.this.dragOverEvent.y);
                    }
                    DropTarget.this.selectedDataType = null;
                    DropTarget.this.selectedOperation = 0;
                    DropTarget.this.notifyListeners(2004, event);
                    if (event.dataType != null) {
                        int i = 0;
                        while (i < allowedTypes.length) {
                            if (allowedTypes[i].type == event.dataType.type) {
                                DropTarget.this.selectedDataType = event.dataType;
                                break;
                            }
                            ++i;
                        }
                    }
                    if (DropTarget.this.selectedDataType != null && (event.detail & allowedOperations) != 0) {
                        DropTarget.this.selectedOperation = event.detail;
                    }
                }
                control = DropTarget.this.control;
                if (control == null || control.isDisposed()) {
                    return;
                }
                control.getDisplay().timerExec(delay, DropTarget.this.dragOverHeartbeat);
            }
        };
    }

    static int checkStyle(int style) {
        if (style == 0) {
            return 2;
        }
        return style;
    }

    static int Drag_Data_Received(int widget, int context, int x, int y, int data, int info, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        target.drag_data_received(widget, context, x, y, data, info, time);
        return 0;
    }

    static int Drag_Drop(int widget, int context, int x, int y, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        return target.drag_drop(widget, context, x, y, time) ? 1 : 0;
    }

    static int Drag_Leave(int widget, int context, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        target.drag_leave(widget, context, time);
        return 0;
    }

    static int Drag_Motion(int widget, int context, int x, int y, int time) {
        DropTarget target = DropTarget.FindDropTarget(widget);
        if (target == null) {
            return 0;
        }
        return target.drag_motion(widget, context, x, y, time) ? 1 : 0;
    }

    static DropTarget FindDropTarget(int handle) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return null;
        }
        Widget widget = display.findWidget(handle);
        if (widget == null) {
            return null;
        }
        return (DropTarget)widget.getData("DropTarget");
    }

    public void addDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        DNDListener typedListener = new DNDListener(listener);
        typedListener.dndWidget = this;
        this.addListener(2002, typedListener);
        this.addListener(2003, typedListener);
        this.addListener(2004, typedListener);
        this.addListener(2005, typedListener);
        this.addListener(2006, typedListener);
        this.addListener(2007, typedListener);
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DropTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    void drag_data_received(int widget, int context, int x, int y, int selection_data, int info, int time) {
        int type;
        int data;
        int format;
        int length;
        DNDEvent event = new DNDEvent();
        if (selection_data == 0 || !this.setEventData(context, x, y, time, event)) {
            this.keyOperation = -1;
            return;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        Object object = null;
        TransferData transferData = new TransferData();
        if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            length = OS.gtk_selection_data_get_length(selection_data);
            format = OS.gtk_selection_data_get_format(selection_data);
            data = OS.gtk_selection_data_get_data(selection_data);
            type = OS.gtk_selection_data_get_data_type(selection_data);
        } else {
            GtkSelectionData gtkSelectionData = new GtkSelectionData();
            OS.memmove(gtkSelectionData, selection_data, GtkSelectionData.sizeof);
            length = gtkSelectionData.length;
            format = gtkSelectionData.format;
            data = gtkSelectionData.data;
            type = gtkSelectionData.type;
        }
        if (data != 0) {
            transferData.type = type;
            transferData.length = length;
            transferData.pValue = data;
            transferData.format = format;
            int i = 0;
            while (i < this.transferAgents.length) {
                Transfer transfer = this.transferAgents[i];
                if (transfer != null && transfer.isSupportedType(transferData)) {
                    object = transfer.nativeToJava(transferData);
                    break;
                }
                ++i;
            }
        }
        if (object == null) {
            this.selectedOperation = 0;
        }
        event.detail = this.selectedOperation;
        event.dataType = transferData;
        event.data = object;
        this.selectedOperation = 0;
        this.notifyListeners(2006, event);
        if ((allowedOperations & event.detail) == event.detail) {
            this.selectedOperation = event.detail;
        }
        OS.g_signal_stop_emission_by_name(widget, OS.drag_data_received);
        OS.gtk_drag_finish(context, this.selectedOperation != 0, this.selectedOperation == 2, time);
    }

    boolean drag_drop(int widget, int context, int x, int y, int time) {
        DNDEvent event = new DNDEvent();
        if (!this.setEventData(context, x, y, time, event)) {
            this.keyOperation = -1;
            return false;
        }
        this.keyOperation = -1;
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        event.dataType = this.selectedDataType;
        event.detail = this.selectedOperation;
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(2007, event);
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        if (this.selectedDataType != null && (event.detail & allowedOperations) == event.detail) {
            this.selectedOperation = event.detail;
        }
        if (this.selectedOperation == 0) {
            return false;
        }
        OS.gtk_drag_get_data(widget, context, this.selectedDataType.type, time);
        return true;
    }

    void drag_leave(int widget, int context, int time) {
        this.updateDragOverHover(0L, null);
        if (this.keyOperation == -1) {
            return;
        }
        this.keyOperation = -1;
        DNDEvent event = new DNDEvent();
        event.widget = this;
        event.time = time;
        event.detail = 0;
        this.notifyListeners(2003, event);
    }

    boolean drag_motion(int widget, int context, int x, int y, int time) {
        DNDEvent event;
        int oldKeyOperation = this.keyOperation;
        if (oldKeyOperation == -1 || !((Boolean)this.control.getData(IS_ACTIVE)).booleanValue()) {
            this.selectedDataType = null;
            this.selectedOperation = 0;
        }
        if (!this.setEventData(context, x, y, time, event = new DNDEvent())) {
            this.keyOperation = -1;
            OS.gdk_drag_status(context, 0, time);
            return false;
        }
        int allowedOperations = event.operations;
        TransferData[] allowedDataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, allowedDataTypes, 0, allowedDataTypes.length);
        if (oldKeyOperation == -1) {
            event.type = 2002;
        } else if (this.keyOperation == oldKeyOperation) {
            event.type = 2004;
            event.dataType = this.selectedDataType;
            event.detail = this.selectedOperation;
        } else {
            event.type = 2005;
            event.dataType = this.selectedDataType;
        }
        this.updateDragOverHover(50L, event);
        this.selectedDataType = null;
        this.selectedOperation = 0;
        this.notifyListeners(event.type, event);
        if (event.detail == 16) {
            int n = event.detail = (allowedOperations & 2) != 0 ? 2 : 0;
        }
        if (event.dataType != null) {
            int i = 0;
            while (i < allowedDataTypes.length) {
                if (allowedDataTypes[i].type == event.dataType.type) {
                    this.selectedDataType = allowedDataTypes[i];
                    break;
                }
                ++i;
            }
        }
        if (this.selectedDataType != null && (allowedOperations & event.detail) != 0) {
            this.selectedOperation = event.detail;
        }
        switch (this.selectedOperation) {
            case 0: {
                OS.gdk_drag_status(context, 0, time);
                break;
            }
            case 1: {
                OS.gdk_drag_status(context, 2, time);
                break;
            }
            case 2: {
                OS.gdk_drag_status(context, 4, time);
                break;
            }
            case 4: {
                OS.gdk_drag_status(context, 8, time);
            }
        }
        if (oldKeyOperation == -1) {
            this.dragOverHeartbeat.run();
        }
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public DropTargetListener[] getDropListeners() {
        Listener[] listeners = this.getListeners(2002);
        int length = listeners.length;
        DropTargetListener[] dropListeners = new DropTargetListener[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            Listener listener = listeners[i];
            if (listener instanceof DNDListener) {
                dropListeners[count] = (DropTargetListener)((DNDListener)listener).getEventListener();
                ++count;
            }
            ++i;
        }
        if (count == length) {
            return dropListeners;
        }
        DropTargetListener[] result = new DropTargetListener[count];
        System.arraycopy(dropListeners, 0, result, 0, count);
        return result;
    }

    public DropTargetEffect getDropTargetEffect() {
        return this.dropEffect;
    }

    int getOperationFromKeyState() {
        boolean shift;
        int[] state = new int[1];
        if (OS.GTK3) {
            int root = OS.gdk_get_default_root_window();
            int device_manager = OS.gdk_display_get_device_manager(OS.gdk_window_get_display(root));
            int pointer = OS.gdk_device_manager_get_client_pointer(device_manager);
            OS.gdk_window_get_device_position(root, pointer, null, null, state);
        } else {
            OS.gdk_window_get_pointer(0, null, null, state);
        }
        boolean ctrl = (state[0] & 4) != 0;
        boolean bl = shift = (state[0] & 1) != 0;
        if (ctrl && shift) {
            return 4;
        }
        if (ctrl) {
            return 1;
        }
        if (shift) {
            return 2;
        }
        return 16;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_motion_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_leave_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_data_received_handler);
        OS.g_signal_handler_disconnect(this.control.handle, this.drag_drop_handler);
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = null;
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
        }
        this.control.setData("DropTarget", null);
        this.control = null;
        this.controlListener = null;
    }

    int opToOsOp(int operation) {
        int osOperation = 0;
        if ((operation & 1) == 1) {
            osOperation |= 2;
        }
        if ((operation & 2) == 2) {
            osOperation |= 4;
        }
        if ((operation & 4) == 4) {
            osOperation |= 8;
        }
        return osOperation;
    }

    int osOpToOp(int osOperation) {
        int operation = 0;
        if ((osOperation & 2) == 2) {
            operation |= 1;
        }
        if ((osOperation & 4) == 4) {
            operation |= 2;
        }
        if ((osOperation & 8) == 8) {
            operation |= 4;
        }
        return operation;
    }

    public void removeDropListener(DropTargetListener listener) {
        if (listener == null) {
            DND.error(4);
        }
        this.removeListener(2002, listener);
        this.removeListener(2003, listener);
        this.removeListener(2004, listener);
        this.removeListener(2005, listener);
        this.removeListener(2006, listener);
        this.removeListener(2007, listener);
    }

    public void setTransfer(Transfer[] transferAgents) {
        int entryHandle;
        if (transferAgents == null) {
            DND.error(4);
        }
        if (this.transferAgents.length != 0) {
            OS.gtk_drag_dest_unset(this.control.handle);
        }
        this.transferAgents = transferAgents;
        GtkTargetEntry[] targets = new GtkTargetEntry[]{};
        int i = 0;
        while (i < transferAgents.length) {
            Transfer transfer = transferAgents[i];
            if (transfer != null) {
                int[] typeIds = transfer.getTypeIds();
                String[] typeNames = transfer.getTypeNames();
                int j = 0;
                while (j < typeIds.length) {
                    GtkTargetEntry entry = new GtkTargetEntry();
                    byte[] buffer = Converter.wcsToMbcs(null, typeNames[j], true);
                    entry.target = OS.g_malloc(buffer.length);
                    C.memmove(entry.target, buffer, buffer.length);
                    entry.info = typeIds[j];
                    GtkTargetEntry[] newTargets = new GtkTargetEntry[targets.length + 1];
                    System.arraycopy(targets, 0, newTargets, 0, targets.length);
                    newTargets[targets.length] = entry;
                    targets = newTargets;
                    ++j;
                }
            }
            ++i;
        }
        int pTargets = OS.g_malloc(targets.length * GtkTargetEntry.sizeof);
        int i2 = 0;
        while (i2 < targets.length) {
            OS.memmove(pTargets + i2 * GtkTargetEntry.sizeof, targets[i2], GtkTargetEntry.sizeof);
            ++i2;
        }
        int actions = this.opToOsOp(this.getStyle());
        if (this.control instanceof Combo && (this.control.getStyle() & 8) == 0 && (entryHandle = OS.gtk_bin_get_child(this.control.handle)) != 0) {
            OS.gtk_drag_dest_unset(entryHandle);
        }
        OS.gtk_drag_dest_set(this.control.handle, 0, pTargets, targets.length, actions);
        int i3 = 0;
        while (i3 < targets.length) {
            OS.g_free(targets[i3].target);
            ++i3;
        }
    }

    public void setDropTargetEffect(DropTargetEffect effect) {
        this.dropEffect = effect;
    }

    boolean setEventData(int context, int x, int y, int time, DNDEvent event) {
        int operation;
        if (context == 0) {
            return false;
        }
        int targets = 0;
        int actions = 0;
        if (OS.GTK3) {
            targets = OS.gdk_drag_context_list_targets(context);
            actions = OS.gdk_drag_context_get_actions(context);
        } else {
            GdkDragContext dragContext = new GdkDragContext();
            OS.memmove(dragContext, context, GdkDragContext.sizeof);
            targets = dragContext.targets;
            actions = dragContext.actions;
        }
        if (targets == 0) {
            return false;
        }
        int style = this.getStyle();
        int operations = this.osOpToOp(actions) & style;
        if (operations == 0) {
            return false;
        }
        this.keyOperation = operation = this.getOperationFromKeyState();
        if (operation == 16) {
            if ((style & 0x10) == 0) {
                operation = (operations & 2) != 0 ? 2 : 0;
            }
        } else if ((operation & operations) == 0) {
            operation = 0;
        }
        int length = OS.g_list_length(targets);
        TransferData[] dataTypes = new TransferData[]{};
        int i = 0;
        while (i < length) {
            int pData = OS.g_list_nth_data(targets, i);
            TransferData data = new TransferData();
            data.type = pData;
            int j = 0;
            while (j < this.transferAgents.length) {
                Transfer transfer = this.transferAgents[j];
                if (transfer != null && transfer.isSupportedType(data)) {
                    TransferData[] newDataTypes = new TransferData[dataTypes.length + 1];
                    System.arraycopy(dataTypes, 0, newDataTypes, 0, dataTypes.length);
                    newDataTypes[dataTypes.length] = data;
                    dataTypes = newDataTypes;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (dataTypes.length == 0) {
            return false;
        }
        int window = OS.GTK_VERSION >= OS.VERSION(2, 14, 0) ? OS.gtk_widget_get_window(this.control.handle) : OS.GTK_WIDGET_WINDOW(this.control.handle);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        Point coordinates = new Point(origin_x[0] + x, origin_y[0] + y);
        event.widget = this;
        event.x = coordinates.x;
        event.y = coordinates.y;
        event.time = time;
        event.feedback = 1;
        event.dataTypes = dataTypes;
        event.dataType = dataTypes[0];
        event.operations = operations;
        event.detail = operation;
        if (this.dropEffect != null) {
            event.item = this.dropEffect.getItem(coordinates.x, coordinates.y);
        }
        return true;
    }

    void updateDragOverHover(long delay, DNDEvent event) {
        if (delay == 0L) {
            this.dragOverStart = 0L;
            this.dragOverEvent = null;
            return;
        }
        this.dragOverStart = System.currentTimeMillis() + delay;
        if (this.dragOverEvent == null) {
            this.dragOverEvent = new DNDEvent();
        }
        this.dragOverEvent.x = event.x;
        this.dragOverEvent.y = event.y;
        TransferData[] dataTypes = new TransferData[event.dataTypes.length];
        System.arraycopy(event.dataTypes, 0, dataTypes, 0, dataTypes.length);
        this.dragOverEvent.dataTypes = dataTypes;
        this.dragOverEvent.operations = event.operations;
        this.dragOverEvent.time = event.time;
    }
}

