/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.registry;

import java.util.ArrayList;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.commons.registry.RegistryBase;

public class RegistryBaseTest {
    private Logger logger = Logger.getLogger(RegistryBaseTest.class);
    private RegistryBase<Object> testRegistry;

    @BeforeClass
    public static void init() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Before
    public void setUp() {
        this.testRegistry = new RegistryBase<Object>(){};
    }

    @Test
    public void testEmptyAfterInitialization() {
        Assert.assertEquals((String)"Registry is not empty after creation", (long)0L, (long)this.testRegistry.getElements().size());
    }

    @Test
    public void testRegisteringObject() {
        Object element = new Object();
        this.testRegistry.registerElement(element);
        Assert.assertEquals((String)"Registry contains more than one element", (long)1L, (long)this.testRegistry.getElements().size());
        Assert.assertSame((String)"Registry contains wrong element", (Object)element, this.testRegistry.getElements().get(0));
    }

    @Test
    public void testRegisteringObjects() {
        int numberOfElements = 10;
        ArrayList<Object> objects = new ArrayList<Object>();
        int i = 0;
        while (i < numberOfElements) {
            Object element = new Object();
            objects.add(element);
            this.testRegistry.registerElement(element);
            ++i;
        }
        Assert.assertEquals((String)"Registry contains wrong number of elements", (long)numberOfElements, (long)this.testRegistry.getElements().size());
        i = 0;
        while (i < numberOfElements) {
            Assert.assertSame(objects.get(i), this.testRegistry.getElements().get(i));
            ++i;
        }
    }

    @Test
    public void testNoDuplicateRegistration() {
        Object element = new Object();
        this.testRegistry.registerElement(element);
        this.testRegistry.registerElement(element);
        Assert.assertEquals((String)"Registry contains more than one element", (long)1L, (long)this.testRegistry.getElements().size());
        Assert.assertSame((String)"Registry contains wrong element", (Object)element, this.testRegistry.getElements().get(0));
    }

    @Test
    public void testNoNullRegistration() {
        this.testRegistry.registerElement(null);
        Assert.assertEquals((String)"Registry contains more than one element", (long)0L, (long)this.testRegistry.getElements().size());
    }

    @Test
    public void testCustomSorting() {
        RegistryBase<Integer> sortingTestRegistry = new RegistryBase<Integer>(){

            protected int compareElements(Integer element1, Integer element2) {
                return element1.compareTo(element2);
            }
        };
        Object[] expected = new Integer[]{0, 1, 2};
        sortingTestRegistry.registerElement((Object)expected[2]);
        sortingTestRegistry.registerElement((Object)expected[0]);
        sortingTestRegistry.registerElement((Object)expected[1]);
        Assert.assertArrayEquals((Object[])expected, (Object[])sortingTestRegistry.getElements().toArray(new Integer[0]));
    }

    @Test
    public void testCustomObjectEquality() {
        RegistryBase<Integer> customEqualityTestRegistry = new RegistryBase<Integer>(){

            protected boolean areElementsConsideredTheSame(Integer element1, Integer element2) {
                return Math.abs(element1 - element2) <= 1;
            }
        };
        Object[] expected = new Integer[]{0, 2};
        customEqualityTestRegistry.registerElement((Object)0);
        customEqualityTestRegistry.registerElement((Object)1);
        customEqualityTestRegistry.registerElement((Object)2);
        Assert.assertArrayEquals((Object[])expected, (Object[])customEqualityTestRegistry.getElements().toArray(new Integer[0]));
    }
}

