/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.emf;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.commons.emf.SPLevoResourceSet;

public class SPLevoResourceSetTest {
    private SPLevoResourceSet rs;

    @BeforeClass
    public static void setUpBeforeClass() {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
    }

    @Before
    public void setUp() {
        this.rs = new SPLevoResourceSet();
    }

    @Test
    public void testFileURIWithSpace() {
        URI testURI = URI.createFileURI((String)"/ab c/def.xmi");
        Resource r = this.rs.createResource(testURI);
        URI actualURI = r.getURI();
        Assert.assertEquals((Object)testURI, (Object)actualURI);
    }

    @Test
    public void testFileURIWithSegment() {
        URI testURI = URI.createFileURI((String)"/ab c/def.xmi");
        testURI = URI.createURI((String)(String.valueOf(testURI.toString()) + "#ABC123"), (boolean)true, (int)2);
        Resource r = this.rs.createResource(testURI);
        URI actualURI = r.getURI();
        Assert.assertEquals((Object)testURI, (Object)actualURI);
    }
}

