/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.registry;

import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.commons.interfaces.IdHavingElement;
import org.splevo.commons.registry.IdBasedRegistryBase;
import org.splevo.commons.registry.RegistryBaseTest;

public class IdBasedRegistryBaseTest {
    private Logger logger = Logger.getLogger(RegistryBaseTest.class);
    private IdBasedRegistryBase<IdHavingElementMock, Integer> testRegistry;

    @BeforeClass
    public static void init() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Before
    public void setUp() {
        this.testRegistry = new IdBasedRegistryBase<IdHavingElementMock, Integer>(){};
    }

    @Test
    public void testGetElementById() {
        IdHavingElementMock element = new IdHavingElementMock(0);
        this.testRegistry.registerElement((Object)element);
        Assert.assertSame((Object)element, (Object)this.testRegistry.getElementById((Object)0));
    }

    @Test
    public void testGetElementByNotRegisteredId() {
        IdHavingElementMock element = new IdHavingElementMock(0);
        this.testRegistry.registerElement((Object)element);
        Assert.assertNull((Object)this.testRegistry.getElementById((Object)1));
    }

    @Test
    public void testNoDuplicateIdRegistration() {
        IdHavingElementMock element = new IdHavingElementMock(0);
        this.testRegistry.registerElement((Object)element);
        this.testRegistry.registerElement((Object)element);
        Assert.assertEquals((String)"Registry contains more than one element", (long)1L, (long)this.testRegistry.getElements().size());
        Assert.assertSame((String)"Registry contains wrong element", (Object)element, this.testRegistry.getElements().get(0));
    }

    @Test
    public void testNoNullRegistration() {
        this.testRegistry.registerElement(null);
        Assert.assertEquals((String)"Registry contains more than one element", (long)0L, (long)this.testRegistry.getElements().size());
    }

    @Test
    public void testNoNullIdRegistration() {
        IdHavingElementMock element = new IdHavingElementMock(null);
        this.testRegistry.registerElement((Object)element);
        Assert.assertEquals((String)"Registry contains more than one element", (long)0L, (long)this.testRegistry.getElements().size());
    }

    private class IdHavingElementMock
    implements IdHavingElement<Integer> {
        private final Integer id;

        public IdHavingElementMock(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }
    }
}

