/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.eclipse;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleException;

public class ExtensionHelper {
    private static final Logger LOGGER = Logger.getLogger(ExtensionHelper.class);

    public static <T> Iterable<T> getAllRegisteredExtensions(String extensionPointId, Class<T> extensionClazz) throws BundleException {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            throw new BundleException("No extension point registry available.");
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointId);
        if (extensionPoint == null) {
            throw new BundleException("No extension point found for the ID " + extensionPointId);
        }
        ArrayList<Object> extensionObjects = new ArrayList<Object>();
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(String.valueOf(extensionClazz.getSimpleName().toLowerCase()) + ".class");
                    if (o != null && extensionClazz.isAssignableFrom(o.getClass())) {
                        extensionObjects.add(o);
                    }
                }
                catch (CoreException e) {
                    LOGGER.error((Object)"Failed to load extensions", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        return extensionObjects;
    }
}

