/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.emf;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class FileResourceHandling {
    public static boolean usePlatformResource(ResourceSet rs) {
        return (Boolean)(rs.getLoadOptions().containsKey((Object)ResourceHandlingOptions.USE_PLATFORM_RESOURCE) ? rs.getLoadOptions().get((Object)ResourceHandlingOptions.USE_PLATFORM_RESOURCE) : ResourceHandlingOptions.USE_PLATFORM_RESOURCE.getDefault());
    }

    public static File getPhysicalFilePath(Resource r) {
        URI resourceURI = r.getURI();
        return FileResourceHandling.getPhysicalFilePath(resourceURI, r.getResourceSet());
    }

    public static File getPhysicalFilePath(URI resourceURI, ResourceSet rs) {
        if (resourceURI.isPlatformResource()) {
            Path p = new Path(resourceURI.toPlatformString(true));
            IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)p);
            return f.getLocation().toFile();
        }
        if (resourceURI.isFile()) {
            return new File(resourceURI.toFileString());
        }
        return null;
    }

    public static enum ResourceHandlingOptions {
        USE_PLATFORM_RESOURCE(ResourcesPlugin.getPlugin() != null);

        private Object defaultValue;

        private ResourceHandlingOptions(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Object getDefault() {
            return this.defaultValue;
        }

        public void setDefault(Object defaultValue) {
            this.defaultValue = defaultValue;
        }
    }
}

