/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.commons.registry;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class RegistryBase<T> {
    protected final List<T> elements = Lists.newArrayList();

    public void registerElement(T element) {
        if (this.isValid(element) && this.isNotRegistered(element)) {
            this.elements.add(element);
        }
    }

    public List<T> getElements() {
        this.sortElements();
        return this.elements;
    }

    protected boolean isValid(T element) {
        return element != null;
    }

    private boolean isNotRegistered(T givenElement) {
        for (T existingElement : this.elements) {
            if (!this.areElementsConsideredTheSame(existingElement, givenElement)) continue;
            return false;
        }
        return true;
    }

    private void sortElements() {
        Collections.sort(this.elements, new Comparator<T>(){

            @Override
            public int compare(T d1, T d2) {
                return RegistryBase.this.compareElements(d1, d2);
            }
        });
    }

    protected int compareElements(T element1, T element2) {
        return 0;
    }

    protected boolean areElementsConsideredTheSame(T element1, T element2) {
        return element1.equals(element2);
    }
}

