/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.diffing;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.splevo.diffing.Differ;
import org.splevo.diffing.DifferRegistry;

public class Activator
implements BundleActivator {
    private static final String DIFFER_EXTENSION_POINT_ID = "org.splevo.diffing.differ";
    private static final String EXTENSION_POINT_ATTR_DIFFER_CLASS = "differ.class";
    private static Logger logger = Logger.getLogger(Activator.class);
    private static BundleContext context;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        List<Differ> differs = this.loadDiffers();
        for (Differ differ : differs) {
            DifferRegistry.getInstance().registerElement(differ);
        }
    }

    public List<Differ> loadDiffers() {
        IExtension[] extensions;
        LinkedList<Differ> differList = new LinkedList<Differ>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            logger.warn((Object)"No extension point registry available.");
            return null;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(DIFFER_EXTENSION_POINT_ID);
        if (extensionPoint == null) {
            logger.warn((Object)"No extension point found for the ID org.splevo.diffing.differ");
            return null;
        }
        IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configurations;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configurations = extension.getConfigurationElements();
            int n3 = configurations.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object o = element.createExecutableExtension(EXTENSION_POINT_ATTR_DIFFER_CLASS);
                    if (o != null && o instanceof Differ) {
                        Differ differ = (Differ)o;
                        differ.init();
                        differList.add(differ);
                    }
                }
                catch (CoreException e) {
                    logger.error((Object)"Failed to load differ extension", (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
        if (this.differIdsNotUnique(differList)) {
            logger.warn((Object)"Two or more differs with the same id loaded.");
        }
        return differList;
    }

    private boolean differIdsNotUnique(List<Differ> differs) {
        LinkedList<String> ids = new LinkedList<String>();
        for (Differ differ : differs) {
            if (ids.contains(differ.getId())) {
                return true;
            }
            ids.add(differ.getId());
        }
        return false;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }
}

