/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.diffing.match;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.resource.IResourceMatcher;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.IEqualityHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class HierarchicalMatchEngine
implements IMatchEngine {
    private static Logger logger = Logger.getLogger(HierarchicalMatchEngine.class);
    private IEqualityHelper equalityHelper = null;
    private EqualityStrategy equalityStrategy = null;
    private IgnoreStrategy ignoreStrategy = null;
    private IResourceMatcher resourceMatcher = null;

    public HierarchicalMatchEngine(IEqualityHelper equalityHelper, EqualityStrategy equalityStrategy, IgnoreStrategy ignoreStrategy, IResourceMatcher resourceMatcher) {
        this.equalityHelper = equalityHelper;
        this.equalityStrategy = equalityStrategy;
        this.ignoreStrategy = ignoreStrategy;
        this.resourceMatcher = resourceMatcher;
    }

    public Comparison match(IComparisonScope scope, Monitor monitor) {
        Notifier left = scope.getLeft();
        Notifier right = scope.getRight();
        Comparison comparison = this.createComparison();
        comparison.setThreeWay(false);
        this.match(comparison, scope, left, right, monitor);
        return comparison;
    }

    protected void match(Comparison comparison, IComparisonScope scope, Notifier left, Notifier right, Monitor monitor) {
        if (left instanceof ResourceSet || right instanceof ResourceSet) {
            this.match(comparison, scope, (ResourceSet)left, (ResourceSet)right, monitor);
        } else if (left instanceof Resource || right instanceof Resource) {
            this.match(comparison, (Resource)left, (Resource)right, monitor);
        } else if (left instanceof EObject || right instanceof EObject) {
            this.match(comparison, (EObject)left, (EObject)right, monitor);
        } else {
            throw new IllegalArgumentException("Unhandled type of elements to match. (" + left + ", " + right + ")");
        }
    }

    protected void match(Comparison comparison, IComparisonScope scope, ResourceSet left, ResourceSet right, Monitor monitor) {
        Iterator leftChildren = scope.getCoveredResources(left);
        Iterator rightChildren = scope.getCoveredResources(right);
        UnmodifiableIterator originChildren = Iterators.emptyIterator();
        IResourceMatcher matcher = this.createResourceMatcher();
        Iterable mappings = matcher.createMappings(leftChildren, rightChildren, (Iterator)originChildren);
        for (MatchResource mapping : mappings) {
            comparison.getMatchedResources().add((Object)mapping);
            Resource leftRes = mapping.getLeft();
            Resource rightRes = mapping.getRight();
            this.match(comparison, leftRes, rightRes, monitor);
        }
    }

    protected void match(Comparison comparison, Resource leftRes, Resource rightRes, Monitor monitor) {
        EList leftElements = new ArrayList();
        EList rightElements = new ArrayList();
        if (leftRes != null) {
            leftElements = leftRes.getContents();
        }
        if (rightRes != null) {
            rightElements = rightRes.getContents();
        }
        List<Match> matches = this.match(comparison, (List<EObject>)leftElements, (List<EObject>)rightElements, monitor);
        comparison.getMatches().addAll(matches);
    }

    protected void match(Comparison comparison, EObject left, EObject right, Monitor monitor) {
        ArrayList leftElements = Lists.newArrayList((Object[])new EObject[]{left});
        ArrayList rightElements = Lists.newArrayList((Object[])new EObject[]{right});
        List<Match> matches = this.match(comparison, leftElements, rightElements, monitor);
        comparison.getMatches().addAll(matches);
    }

    private List<Match> match(Comparison comparison, List<EObject> leftElements, List<EObject> rightElements, Monitor monitor) {
        ArrayList<Match> matches = new ArrayList<Match>();
        List<EObject> leftElementsInScope = this.filterIgnoredElements(leftElements);
        List<EObject> rightElementsInScope = this.filterIgnoredElements(rightElements);
        for (EObject leftElement : leftElementsInScope) {
            Match match = CompareFactory.eINSTANCE.createMatch();
            match.setLeft(leftElement);
            for (EObject rightElement : rightElementsInScope) {
                if (!this.equalityStrategy.areEqual(leftElement, rightElement)) continue;
                rightElementsInScope.remove(rightElement);
                match.setRight(rightElement);
                List<Match> subMatches = this.match(comparison, (List<EObject>)leftElement.eContents(), (List<EObject>)rightElement.eContents(), monitor);
                match.getSubmatches().addAll(subMatches);
                break;
            }
            matches.add(match);
        }
        List<Match> rightOnlyMatches = this.createMatchesForRightElements(rightElementsInScope);
        matches.addAll(rightOnlyMatches);
        return matches;
    }

    private List<Match> createMatchesForRightElements(List<EObject> elements) {
        ArrayList rightMatches = Lists.newArrayList();
        for (EObject element : elements) {
            Match match = CompareFactory.eINSTANCE.createMatch();
            match.setRight(element);
            rightMatches.add(match);
        }
        return rightMatches;
    }

    private List<EObject> filterIgnoredElements(List<EObject> elements) {
        ArrayList<EObject> elementsInScope = new ArrayList<EObject>();
        if (elements == null) {
            return elementsInScope;
        }
        for (EObject object : elements) {
            if (object == null) {
                logger.error((Object)("Null object provided to ignore filter. Containing element list: " + elements));
                continue;
            }
            if (this.ignoreStrategy.ignore(object)) continue;
            elementsInScope.add(object);
        }
        return elementsInScope;
    }

    protected IResourceMatcher createResourceMatcher() {
        return this.resourceMatcher;
    }

    private Comparison createComparison() {
        Comparison comparison = CompareFactory.eINSTANCE.createComparison();
        comparison.eAdapters().add((Object)this.equalityHelper);
        this.equalityHelper.setTarget((Notifier)comparison);
        return comparison;
    }

    public static interface EqualityStrategy {
        public boolean areEqual(EObject var1, EObject var2);
    }

    public static interface IgnoreStrategy {
        public boolean ignore(EObject var1);
    }

    public static enum ResourceMatcherMode {
        DEFAULT,
        HIERARCHICAL;

    }
}

