/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.diffing.util;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public final class NormalizationUtil {
    private static Logger logger = Logger.getLogger(NormalizationUtil.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private NormalizationUtil() {
    }

    public static String normalize(String original, Map<Pattern, String> normalizations) {
        String renamed = Strings.nullToEmpty((String)original);
        for (Pattern pattern : normalizations.keySet()) {
            String replaceString = normalizations.get(pattern);
            renamed = pattern.matcher(renamed).replaceAll(replaceString);
        }
        return renamed;
    }

    public static String normalizeNamespace(String namespace, LinkedHashMap<Pattern, String> normalizations) {
        namespace = Strings.nullToEmpty((String)namespace);
        for (Pattern pattern : normalizations.keySet()) {
            String replacement = normalizations.get(pattern);
            namespace = pattern.matcher(namespace).replaceAll(replacement);
        }
        return namespace;
    }

    public static LinkedHashMap<Pattern, String> loadRemoveNormalizations(String configString, String suffix) {
        suffix = Strings.nullToEmpty((String)suffix);
        configString = Strings.nullToEmpty((String)configString);
        LinkedHashMap normalizations = Maps.newLinkedHashMap();
        Iterable entries = Splitter.on((String)LINE_SEPARATOR).omitEmptyStrings().trimResults().split((CharSequence)configString);
        for (String entry : entries) {
            Pattern pattern;
            String patternString;
            if (entry.startsWith("*")) {
                patternString = "(.*)" + entry.substring(1) + suffix;
                pattern = Pattern.compile(patternString);
                normalizations.put(pattern, "$1" + suffix);
                continue;
            }
            if (entry.endsWith("*")) {
                patternString = String.valueOf(entry.substring(0, entry.length())) + "(.*)" + suffix;
                pattern = Pattern.compile(patternString);
                normalizations.put(pattern, "$1" + suffix);
                continue;
            }
            logger.warn((Object)("Classifier normalization config without * wildcard: " + entry));
        }
        return normalizations;
    }

    public static LinkedHashMap<Pattern, String> loadReplaceNormalizations(String configString) {
        String normalizations = Strings.nullToEmpty((String)configString);
        Iterable entries = Splitter.on((String)LINE_SEPARATOR).omitEmptyStrings().trimResults().split((CharSequence)normalizations);
        LinkedHashMap uriNormalizationPatterns = Maps.newLinkedHashMap();
        for (String entry : entries) {
            ArrayList pair = Lists.newArrayList((Iterable)Splitter.on((String)"|").trimResults().split((CharSequence)entry));
            if (pair.size() != 2) {
                logger.warn((Object)("Invalid package normalization config: " + entry));
                continue;
            }
            Pattern pattern = Pattern.compile((String)pair.get(0));
            uriNormalizationPatterns.put(pattern, (String)pair.get(1));
        }
        return uriNormalizationPatterns;
    }
}

