/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.fm.builder;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.splevo.fm.builder.FeatureModelBuilder;
import org.splevo.fm.builder.FeatureModelBuilderRegistry;

public class InnerFeatureModelBuilderRegistryTest {
    private FeatureModelBuilderRegistry.InnerFeatureModelBuilderRegistry subject;

    @Before
    public void setUp() {
        this.subject = FeatureModelBuilderRegistry.getInstance();
    }

    @After
    public void tearDown() {
        FeatureModelBuilderRegistry.getInstance().getElements().clear();
    }

    @Test
    public void testGetIdByLabelBasic() {
        FeatureModelBuilder<Object> fmBuilderMock = InnerFeatureModelBuilderRegistryTest.createFeatureModelBuilderMock("0", "a");
        this.subject.registerElement(fmBuilderMock);
        Assert.assertEquals((Object)"0", (Object)this.subject.getIdByLabel("a"));
    }

    @Test
    public void testGetIdByLabelWithMultipleItems() {
        this.subject.registerElement(InnerFeatureModelBuilderRegistryTest.createFeatureModelBuilderMock("0", "a"));
        this.subject.registerElement(InnerFeatureModelBuilderRegistryTest.createFeatureModelBuilderMock("1", "b"));
        this.subject.registerElement(InnerFeatureModelBuilderRegistryTest.createFeatureModelBuilderMock("2", "c"));
        Assert.assertEquals((Object)"1", (Object)this.subject.getIdByLabel("b"));
    }

    @Test
    public void testGetIdByLabelReturnsNullOnEmptyRegistry() {
        Assert.assertNull((Object)this.subject.getIdByLabel("a"));
    }

    @Test
    public void testGetIdByLabelReturnsNullOnMissingLabel() {
        this.subject.registerElement(InnerFeatureModelBuilderRegistryTest.createFeatureModelBuilderMock("0", "a"));
        Assert.assertNull((Object)this.subject.getIdByLabel("b"));
    }

    private static FeatureModelBuilder<Object> createFeatureModelBuilderMock(String id, String label) {
        FeatureModelBuilder fmBuilderMock = (FeatureModelBuilder)Mockito.mock(FeatureModelBuilder.class);
        Mockito.when((Object)fmBuilderMock.getId()).thenReturn((Object)id);
        Mockito.when((Object)fmBuilderMock.getLabel()).thenReturn((Object)label);
        return fmBuilderMock;
    }
}

