/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.fm.builder;

import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.eclipse.featuremodel.FeatureModel;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.fm.emffeaturemodel.builder.EMFFeatureModelBuilder;
import org.splevo.tests.SPLevoTestUtil;
import org.splevo.vpm.variability.VariationPointModel;

public class EMFFeatureModelBuilderTest {
    private Logger logger = Logger.getLogger(EMFFeatureModelBuilderTest.class);

    @BeforeClass
    public static void setUp() {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
    }

    @Test
    public void testBuildFeatureModel() throws Exception {
        VariationPointModel vpm = SPLevoTestUtil.loadGCDVPMModel();
        EMFFeatureModelBuilder builder = new EMFFeatureModelBuilder();
        FeatureModel fm = (FeatureModel)builder.build(vpm, "TestFeature").getModel();
        Assert.assertNotNull((String)"No Feature Model Created", (Object)fm);
        Assert.assertNotNull((String)"No root feature created", (Object)fm.getRoot());
        Assert.assertEquals((String)"Wrong number of top level features", (long)7L, (long)fm.getRoot().getChildren().size());
    }
}

