/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.fm.emffeaturemodel.builder;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.featuremodel.FeatureModel;
import org.eclipse.featuremodel.FeatureModelPackage;

public class FeatureModelUtil {
    public static final String FEATURE_MODEL_FILE_EXTENSION = "featuremodel";

    public static FeatureModel loadFeatureModel(File featureModelFile) throws IOException {
        FeatureModelPackage.eINSTANCE.eClass();
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put(FEATURE_MODEL_FILE_EXTENSION, new XMIResourceFactoryImpl());
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource r = rs.createResource(URI.createPlatformResourceURI((String)featureModelFile.getPath(), (boolean)true));
        r.load(null);
        EcoreUtil.resolveAll((ResourceSet)rs);
        EObject model = (EObject)r.getContents().get(0);
        if (!(model instanceof FeatureModel)) {
            throw new IOException("Model is not a valid feature model: " + model.getClass().getName());
        }
        FeatureModel featureModel = (FeatureModel)model;
        return featureModel;
    }

    public static void save(FeatureModel featureModel, File filePath) throws IOException {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put(FEATURE_MODEL_FILE_EXTENSION, new XMIResourceFactoryImpl());
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.createResource(URI.createPlatformResourceURI((String)filePath.getPath(), (boolean)true));
        resource.getContents().add((Object)featureModel);
        resource.save(Collections.EMPTY_MAP);
    }
}

