/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.algorithm.clones.baxtor;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.emftext.language.java.commons.Commentable;
import org.splevo.jamopp.algorithm.clones.baxtor.CloneDetectionType;
import org.splevo.jamopp.diffing.similarity.SimilarityChecker;

public class CloneDetector {
    private final CloneDetectionType detectionType;
    private final SimilarityChecker similarityChecker;

    public CloneDetector(CloneDetectionType detectionType) {
        this.detectionType = detectionType;
        this.similarityChecker = new SimilarityChecker();
    }

    public boolean isClone(Commentable commentable1, Commentable commentable2) {
        if (commentable1 == null || commentable2 == null) {
            return false;
        }
        if (commentable1 == commentable2) {
            return true;
        }
        if (commentable1.eClass() != commentable2.eClass()) {
            return false;
        }
        if (this.detectionType == CloneDetectionType.EXACT && !this.similarityChecker.isSimilar((EObject)commentable1, (EObject)commentable2, false).booleanValue()) {
            return false;
        }
        return this.wholeTreeCloned(commentable1, commentable2);
    }

    public boolean isClone(List<Commentable> list1, List<Commentable> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() == 0 || list2.size() == 0) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<Commentable> iterator1 = list1.iterator();
        Iterator<Commentable> iterator2 = list2.iterator();
        while (iterator1.hasNext()) {
            Commentable commentable2;
            Commentable commentable1 = iterator1.next();
            if (this.isClone(commentable1, commentable2 = iterator2.next())) continue;
            return false;
        }
        return true;
    }

    private boolean wholeTreeCloned(Commentable commentable1, Commentable commentable2) {
        TreeIterator commentable1Contents = commentable1.eAllContents();
        TreeIterator commentable2Contents = commentable2.eAllContents();
        while (commentable1Contents.hasNext() && commentable2Contents.hasNext()) {
            EObject content1 = (EObject)commentable1Contents.next();
            EObject content2 = (EObject)commentable2Contents.next();
            if (content1.eClass() != content2.eClass()) {
                return false;
            }
            if (this.detectionType != CloneDetectionType.EXACT || this.similarityChecker.isSimilar((EObject)commentable1, (EObject)commentable2, false).booleanValue()) continue;
            return false;
        }
        return !commentable1Contents.hasNext() && !commentable2Contents.hasNext();
    }
}

