/*******************************************************************************
 * Copyright (c) 2014
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Benjamin Klatt - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.splevo.jamopp.diffing.jamoppdiff.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.splevo.jamopp.diffing.jamoppdiff.util.JaMoPPDiffAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class JaMoPPDiffItemProviderAdapterFactory extends JaMoPPDiffAdapterFactory implements
        ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public JaMoPPDiffItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.StatementChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected StatementChangeItemProvider statementChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.StatementChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createStatementChangeAdapter() {
        if (statementChangeItemProvider == null) {
            statementChangeItemProvider = new StatementChangeItemProvider(this);
        }

        return statementChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.ImportChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ImportChangeItemProvider importChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.ImportChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createImportChangeAdapter() {
        if (importChangeItemProvider == null) {
            importChangeItemProvider = new ImportChangeItemProvider(this);
        }

        return importChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.ClassChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ClassChangeItemProvider classChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.ClassChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createClassChangeAdapter() {
        if (classChangeItemProvider == null) {
            classChangeItemProvider = new ClassChangeItemProvider(this);
        }

        return classChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.FieldChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FieldChangeItemProvider fieldChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.FieldChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFieldChangeAdapter() {
        if (fieldChangeItemProvider == null) {
            fieldChangeItemProvider = new FieldChangeItemProvider(this);
        }

        return fieldChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.PackageChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected PackageChangeItemProvider packageChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.PackageChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createPackageChangeAdapter() {
        if (packageChangeItemProvider == null) {
            packageChangeItemProvider = new PackageChangeItemProvider(this);
        }

        return packageChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.MethodChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected MethodChangeItemProvider methodChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.MethodChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createMethodChangeAdapter() {
        if (methodChangeItemProvider == null) {
            methodChangeItemProvider = new MethodChangeItemProvider(this);
        }

        return methodChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.ConstructorChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ConstructorChangeItemProvider constructorChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.ConstructorChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createConstructorChangeAdapter() {
        if (constructorChangeItemProvider == null) {
            constructorChangeItemProvider = new ConstructorChangeItemProvider(this);
        }

        return constructorChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.EnumChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EnumChangeItemProvider enumChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.EnumChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createEnumChangeAdapter() {
        if (enumChangeItemProvider == null) {
            enumChangeItemProvider = new EnumChangeItemProvider(this);
        }

        return enumChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CompilationUnitChangeItemProvider compilationUnitChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createCompilationUnitChangeAdapter() {
        if (compilationUnitChangeItemProvider == null) {
            compilationUnitChangeItemProvider = new CompilationUnitChangeItemProvider(this);
        }

        return compilationUnitChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.InterfaceChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected InterfaceChangeItemProvider interfaceChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.InterfaceChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createInterfaceChangeAdapter() {
        if (interfaceChangeItemProvider == null) {
            interfaceChangeItemProvider = new InterfaceChangeItemProvider(this);
        }

        return interfaceChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.ImplementsChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ImplementsChangeItemProvider implementsChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.ImplementsChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createImplementsChangeAdapter() {
        if (implementsChangeItemProvider == null) {
            implementsChangeItemProvider = new ImplementsChangeItemProvider(this);
        }

        return implementsChangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.splevo.jamopp.diffing.jamoppdiff.ExtendsChange} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ExtendsChangeItemProvider extendsChangeItemProvider;

    /**
     * This creates an adapter for a {@link org.splevo.jamopp.diffing.jamoppdiff.ExtendsChange}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createExtendsChangeAdapter() {
        if (extendsChangeItemProvider == null) {
            extendsChangeItemProvider = new ExtendsChangeItemProvider(this);
        }

        return extendsChangeItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose() {
        if (statementChangeItemProvider != null)
            statementChangeItemProvider.dispose();
        if (importChangeItemProvider != null)
            importChangeItemProvider.dispose();
        if (classChangeItemProvider != null)
            classChangeItemProvider.dispose();
        if (fieldChangeItemProvider != null)
            fieldChangeItemProvider.dispose();
        if (packageChangeItemProvider != null)
            packageChangeItemProvider.dispose();
        if (methodChangeItemProvider != null)
            methodChangeItemProvider.dispose();
        if (constructorChangeItemProvider != null)
            constructorChangeItemProvider.dispose();
        if (enumChangeItemProvider != null)
            enumChangeItemProvider.dispose();
        if (compilationUnitChangeItemProvider != null)
            compilationUnitChangeItemProvider.dispose();
        if (interfaceChangeItemProvider != null)
            interfaceChangeItemProvider.dispose();
        if (implementsChangeItemProvider != null)
            implementsChangeItemProvider.dispose();
        if (extendsChangeItemProvider != null)
            extendsChangeItemProvider.dispose();
    }

}
