/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.collect.Sets;
import java.io.File;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.imports.ClassifierImport;
import org.emftext.language.java.statements.LocalVariableStatement;
import org.emftext.language.java.statements.Statement;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.ImportChange;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;

public class VariableDeclarationStatementDiffingTest {
    private Logger logger = Logger.getLogger(VariableDeclarationStatementDiffingTest.class);
    private static final String BASE_PATH = "testmodels/implementation/variabledeclaration/";

    @BeforeClass
    public static void setUp() {
        TestUtil.setUp();
    }

    @Test
    public void testVariableDeclarationDiff() throws Exception {
        File fileLeading = new File("testmodels/implementation/variabledeclaration/a/A.java");
        File fileIntegration = new File("testmodels/implementation/variabledeclaration/b/A.java");
        ResourceSet rsLeading = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{fileLeading}));
        ResourceSet rsIntegration = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{fileIntegration}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsLeading, rsIntegration, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        for (Diff diff : differences) {
            this.logger.debug((Object)(diff.getKind() + ": " + TestUtil.printDiff(diff)));
        }
        Assert.assertThat((String)"Difference should contain three diffs", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)3));
        for (Diff diff : differences) {
            if (diff instanceof ImportChange) {
                ImportChange importChange = (ImportChange)diff;
                ClassifierImport classifierImport = (ClassifierImport)importChange.getChangedImport();
                String importedClass = classifierImport.getClassifier().getName();
                if (importChange.getKind() == DifferenceKind.ADD) {
                    Assert.assertThat((String)"Wrong added import type", (Object)importedClass, (Matcher)CoreMatchers.is((Object)"BigDecimal"));
                    continue;
                }
                if (importChange.getKind() != DifferenceKind.DELETE) continue;
                Assert.assertThat((String)"Wrong deleted import type", (Object)importedClass, (Matcher)CoreMatchers.is((Object)"BigInteger"));
                continue;
            }
            if (diff instanceof StatementChange) {
                Statement changedStatement = ((StatementChange)diff).getChangedStatement();
                Assert.assertThat((String)"Wrong statement type", (Object)changedStatement, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(LocalVariableStatement.class)));
                continue;
            }
            Assert.fail((String)("Unexpected diff type detected: " + diff));
        }
    }

    @Test
    public void testNewVariable() throws Exception {
        File fileLeading = new File("testmodels/implementation/variabledeclaration/a/MultipleVariables.java");
        File fileIntegration = new File("testmodels/implementation/variabledeclaration/b/MultipleVariables.java");
        ResourceSet rsLeading = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{fileLeading}));
        ResourceSet rsIntegration = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{fileIntegration}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsLeading, rsIntegration, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        for (Diff diff : differences) {
            this.logger.debug((Object)(diff.getKind() + ": " + TestUtil.printDiff(diff)));
        }
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testStringInitialization() throws Exception {
        File fileLeading = new File("testmodels/implementation/variabledeclaration/a/StringInitialization.java");
        File fileIntegration = new File("testmodels/implementation/variabledeclaration/b/StringInitialization.java");
        ResourceSet rsLeading = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{fileLeading}));
        ResourceSet rsIntegration = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{fileIntegration}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsLeading, rsIntegration, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

