/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.members.Field;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.FieldChange;
import org.splevo.jamopp.diffing.jamoppdiff.ImportChange;
import org.splevo.jamopp.diffing.jamoppdiff.StatementChange;

public class DerivedCopyTest {
    @BeforeClass
    public static void initTest() throws Exception {
        TestUtil.setUp();
    }

    @Test
    public void testDerivedCopyWithNoChange() throws Exception {
        String basePath = "testmodels/implementation/derivedcopy/";
        ResourceSet setA = TestUtil.extractModel(String.valueOf(basePath) + "a");
        ResourceSet setB = TestUtil.extractModel(String.valueOf(basePath) + "b");
        StringBuilder packageMapping = new StringBuilder();
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Custom");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup", "true");
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        Assert.assertThat((String)"One match of original and derived class", (Object)comparison.getMatchedResources().size(), (Matcher)CoreMatchers.is((Object)1));
        MatchResource resourceMatch = (MatchResource)comparison.getMatchedResources().get(0);
        Assert.assertThat((String)"ResourceMatch must have left set", (Object)resourceMatch.getLeft(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)"ResourceMatch must have right set", (Object)resourceMatch.getRight(), (Matcher)CoreMatchers.notNullValue());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"No diff expected due to class match", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testDerivedCopyWithIgnoreFields() throws Exception {
        String basePath = "testmodels/implementation/derivedcopyfield/";
        ResourceSet setA = TestUtil.extractModel(String.valueOf(basePath) + "a");
        ResourceSet setB = TestUtil.extractModel(String.valueOf(basePath) + "b");
        StringBuilder packageMapping = new StringBuilder();
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Custom");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup", "true");
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Exprected detection: 1 added public field", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        Diff diff = (Diff)differences.get(0);
        Assert.assertThat((Object)diff.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Assert.assertThat((Object)diff, (Matcher)CoreMatchers.instanceOf(FieldChange.class));
        Field field = ((FieldChange)diff).getChangedField();
        Assert.assertThat((Object)field.getName(), (Matcher)CoreMatchers.is((Object)"newField"));
    }

    @Test
    public void testDerivedCopyWithIgnoreImports() throws Exception {
        String basePath = "testmodels/implementation/derivedcopyimport/";
        ResourceSet setA = TestUtil.extractModel(String.valueOf(basePath) + "a");
        ResourceSet setB = TestUtil.extractModel(String.valueOf(basePath) + "b");
        StringBuilder packageMapping = new StringBuilder();
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Custom");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup", "true");
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"No diff because not present imports must not be detected as deleted", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testDerivedCopyWithIgnoreImportsCounterpart() throws Exception {
        String basePath = "testmodels/implementation/derivedcopyimport/";
        ResourceSet setA = TestUtil.extractModel(String.valueOf(basePath) + "a");
        ResourceSet setB = TestUtil.extractModel(String.valueOf(basePath) + "b");
        StringBuilder packageMapping = new StringBuilder();
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Custom");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup", "true");
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup.Imports", null);
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Import delete must be detected if filter is set to false", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)2));
        Diff diff = (Diff)differences.get(0);
        Assert.assertThat((String)"Wrong change detected", (Object)diff, (Matcher)CoreMatchers.instanceOf(ImportChange.class));
        Assert.assertThat((String)"Wrong change kind detected", (Object)diff.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.DELETE));
    }

    @Test
    public void testDerivedCopyWithChangedMethod() throws Exception {
        String basePath = "testmodels/implementation/derivedcopymethod/";
        ResourceSet setA = TestUtil.extractModel(String.valueOf(basePath) + "a");
        ResourceSet setB = TestUtil.extractModel(String.valueOf(basePath) + "b");
        StringBuilder packageMapping = new StringBuilder();
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Custom");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup", "true");
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        for (Diff diff : differences) {
            if (diff.getKind() == DifferenceKind.ADD) {
                Assert.assertThat((String)"ADD of wrong type detected", (Object)diff, (Matcher)CoreMatchers.instanceOf(StatementChange.class));
                continue;
            }
            Assert.fail((String)("Change of unexpected kind detected: " + diff.getKind()));
        }
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void testDerivedCopyWithChangedMethodCounterpart() throws Exception {
        String basePath = "testmodels/implementation/derivedcopymethod/";
        ResourceSet setA = TestUtil.extractModel(String.valueOf(basePath) + "a");
        ResourceSet setB = TestUtil.extractModel(String.valueOf(basePath) + "b");
        StringBuilder packageMapping = new StringBuilder();
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Custom");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup", "true");
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup.Methods", null);
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"Wrong number of differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    public void testDerivedCopyWithIgnoreConstructor() throws Exception {
        String basePath = "testmodels/implementation/derivedcopyconstructor/";
        ResourceSet setA = TestUtil.extractModel(String.valueOf(basePath) + "a");
        ResourceSet setB = TestUtil.extractModel(String.valueOf(basePath) + "b");
        StringBuilder packageMapping = new StringBuilder();
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Custom");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        diffOptions.put("JaMoPP.Differ.Derived.Copy.Cleanup", "true");
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"There should be no differences", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

