/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import com.google.common.collect.Sets;
import java.io.File;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.emftext.language.java.members.Field;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.FieldChange;

public class FieldDeclarationTest {
    private String basePathA = "testmodels/implementation/fielddeclaration/a/";
    private String basePathB = "testmodels/implementation/fielddeclaration/b/";

    @Test
    public void testArrayFieldDeclarationDiff() throws Exception {
        TestUtil.setUp();
        File testFileA = new File(String.valueOf(this.basePathA) + "ArrayFieldDeclarationChange.java");
        File testFileB = new File(String.valueOf(this.basePathB) + "ArrayFieldDeclarationChange.java");
        ResourceSet rsA = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsB = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsA, rsB, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"1 difference should be detected", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        FieldChange change = (FieldChange)differences.get(0);
        Assert.assertThat((String)"Wrong diff kind", (Object)change.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.CHANGE));
        Assert.assertThat((String)"Diff should be FieldChange", (Object)change, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FieldChange.class)));
        Field field = change.getChangedField();
        Assert.assertThat((String)"Wrong field name", (Object)field.getName(), (Matcher)CoreMatchers.is((Object)"newValueArray"));
    }

    @Test
    public void testNewInTheMiddleDiff() throws Exception {
        TestUtil.setUp();
        File testFileA = new File(String.valueOf(this.basePathA) + "NewInTheMiddle.java");
        File testFileB = new File(String.valueOf(this.basePathB) + "NewInTheMiddle.java");
        ResourceSet rsLeading = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsIntegration = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsLeading, rsIntegration, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"1 difference should be detected", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        FieldChange change = (FieldChange)differences.get(0);
        Assert.assertThat((String)"Diff should be FieldChange", (Object)change, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FieldChange.class)));
        Assert.assertThat((String)"Wrong diff kind", (Object)change.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.ADD));
        Field field = change.getChangedField();
        Assert.assertThat((String)"Wrong field name", (Object)field.getName(), (Matcher)CoreMatchers.is((Object)"newField"));
    }

    @Test
    public void testRemovedFromTheMiddleDiff() throws Exception {
        TestUtil.setUp();
        File testFileA = new File(String.valueOf(this.basePathA) + "RemovedFromTheMiddle.java");
        File testFileB = new File(String.valueOf(this.basePathB) + "RemovedFromTheMiddle.java");
        ResourceSet rsLeading = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileA}));
        ResourceSet rsIntegration = TestUtil.loadResourceSet(Sets.newHashSet((Object[])new File[]{testFileB}));
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Comparison comparison = differ.doDiff(rsLeading, rsIntegration, TestUtil.getDiffOptions());
        EList differences = comparison.getDifferences();
        Assert.assertThat((String)"1 difference should be detected", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)1));
        FieldChange change = (FieldChange)differences.get(0);
        Assert.assertThat((String)"Diff should be FieldChange", (Object)change, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(FieldChange.class)));
        Assert.assertThat((String)"Wrong diff kind", (Object)change.getKind(), (Matcher)CoreMatchers.is((Object)DifferenceKind.DELETE));
        Field field = change.getChangedField();
        Assert.assertThat((String)"Wrong field name", (Object)field.getName(), (Matcher)CoreMatchers.is((Object)"removeField"));
    }
}

