/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.splevo.jamopp.diffing.JaMoPPDiffer;
import org.splevo.jamopp.diffing.TestUtil;
import org.splevo.jamopp.diffing.jamoppdiff.CompilationUnitChange;

public class RenamingTest {
    private static final String BASE_PATH = "testmodels/implementation/renaming/";
    private Logger logger = Logger.getLogger(RenamingTest.class);
    private static ResourceSet setA;
    private static ResourceSet setB;

    @BeforeClass
    public static void initTest() throws Exception {
        TestUtil.setUp();
        setA = TestUtil.extractModel("testmodels/implementation/renaming/a");
        setB = TestUtil.extractModel("testmodels/implementation/renaming/b");
    }

    @Test
    public void testDoDiff() throws Exception {
        TestUtil.setUp();
        StringBuilder packageMapping = new StringBuilder();
        packageMapping.append("de.splevo.cust.test|de.splevo.test");
        StringBuilder classifierNormalization = new StringBuilder();
        classifierNormalization.append("*Cust");
        JaMoPPDiffer differ = new JaMoPPDiffer();
        Map<String, String> diffOptions = TestUtil.getDiffOptions();
        diffOptions.put("JaMoPP.Java.Package.Normalization.Pattern", packageMapping.toString());
        diffOptions.put("JaMoPP.Java.Classifier.Normalization.Pattern", classifierNormalization.toString());
        Comparison comparison = differ.doDiff(setA, setB, diffOptions);
        Assert.assertThat((String)"Should only match two test classes", (Object)comparison.getMatchedResources().size(), (Matcher)CoreMatchers.is((Object)2));
        EList differences = comparison.getDifferences();
        for (Diff diffElement : differences) {
            this.logger.debug((Object)diffElement.getClass().getSimpleName());
            if (!(diffElement instanceof CompilationUnitChange)) continue;
            CompilationUnitChange change = (CompilationUnitChange)diffElement;
            this.logger.debug((Object)change.getChangedCompilationUnit().getName());
        }
        Assert.assertThat((String)"No difference should exist", (Object)differences.size(), (Matcher)CoreMatchers.is((Object)0));
    }
}

