/*
 * Decompiled with CFR 0.152.
 */
package org.splevo.jamopp.diffing.scope;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.emftext.language.java.containers.CompilationUnit;
import org.emftext.language.java.containers.Package;
import org.emftext.language.java.containers.util.ContainersSwitch;
import org.emftext.language.java.members.Field;
import org.emftext.language.java.members.util.MembersSwitch;
import org.emftext.language.java.references.PackageReference;
import org.emftext.language.java.references.util.ReferencesSwitch;
import org.emftext.language.java.types.PrimitiveType;
import org.emftext.language.java.types.Type;
import org.emftext.language.java.types.TypeReference;
import org.emftext.language.java.types.util.TypesSwitch;
import org.emftext.language.java.variables.Variable;
import org.emftext.language.java.variables.util.VariablesSwitch;
import org.splevo.jamopp.diffing.util.JaMoPPModelUtil;

public class IgnoreSwitch
extends ComposedSwitch<Boolean> {
    private static Logger logger = Logger.getLogger(IgnoreSwitch.class);
    private List<String> ignorePackages = new ArrayList<String>();

    public IgnoreSwitch(List<String> ignorePackages) {
        this.ignorePackages.addAll(ignorePackages);
        this.addSwitch((Switch)new TypesIgnoreSwitch());
        this.addSwitch((Switch)new MembersIgnoreSwitch());
        this.addSwitch((Switch)new VariablesIgnoreSwitch());
        this.addSwitch((Switch)new ContainersIgnoreSwitch());
        this.addSwitch((Switch)new ReferencesIgnoreSwitch());
    }

    public Boolean defaultCase(EObject object) {
        return Boolean.FALSE;
    }

    public Boolean composedDoSwitch(EObject eObject) {
        return (Boolean)this.doSwitch(eObject);
    }

    public Boolean shouldBeIgnored(String packagePath) {
        for (String regex : this.ignorePackages) {
            if (!packagePath.matches(regex)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private class ContainersIgnoreSwitch
    extends ContainersSwitch<Boolean> {
        private ContainersIgnoreSwitch() {
        }

        public Boolean casePackage(Package object) {
            String packagePath = JaMoPPModelUtil.buildNamespacePath((EObject)object);
            return IgnoreSwitch.this.shouldBeIgnored(packagePath);
        }

        public Boolean caseCompilationUnit(CompilationUnit object) {
            String packagePath = JaMoPPModelUtil.buildNamespacePath((EObject)object);
            return IgnoreSwitch.this.shouldBeIgnored(packagePath);
        }
    }

    private class MembersIgnoreSwitch
    extends MembersSwitch<Boolean> {
        private MembersIgnoreSwitch() {
        }

        public Boolean defaultCase(EObject object) {
            if (object.eContainer() != null) {
                return IgnoreSwitch.this.composedDoSwitch(object.eContainer());
            }
            if (object instanceof Field && "length".equals(((Field)object).getName())) {
                return Boolean.TRUE;
            }
            logger.warn((Object)("An unexpected member element without a container: " + object));
            return Boolean.TRUE;
        }
    }

    private class ReferencesIgnoreSwitch
    extends ReferencesSwitch<Boolean> {
        private ReferencesIgnoreSwitch() {
        }

        public Boolean defaultCase(EObject object) {
            if (object.eContainer() != null) {
                return IgnoreSwitch.this.composedDoSwitch(object.eContainer());
            }
            if (!(object instanceof PackageReference)) {
                logger.warn((Object)("A reference element without a container: " + object));
            }
            return Boolean.TRUE;
        }
    }

    private class TypesIgnoreSwitch
    extends TypesSwitch<Boolean> {
        private TypesIgnoreSwitch() {
        }

        public Boolean caseType(Type object) {
            String packagePath = JaMoPPModelUtil.buildNamespacePath((EObject)object);
            return IgnoreSwitch.this.shouldBeIgnored(packagePath);
        }

        public Boolean casePrimitiveType(PrimitiveType object) {
            return Boolean.FALSE;
        }

        public Boolean caseTypeReference(TypeReference object) {
            if (object.eContainer() != null) {
                return IgnoreSwitch.this.composedDoSwitch(object.eContainer());
            }
            logger.warn((Object)("A type reference element without a container: " + object));
            return Boolean.TRUE;
        }
    }

    private class VariablesIgnoreSwitch
    extends VariablesSwitch<Boolean> {
        private VariablesIgnoreSwitch() {
        }

        public Boolean caseVariable(Variable object) {
            if (object.eContainer() != null) {
                return IgnoreSwitch.this.composedDoSwitch(object.eContainer());
            }
            logger.warn((Object)("A variable element without a container: " + object));
            return Boolean.TRUE;
        }
    }
}

